.intel_syntax noprefix

.text 
.global tr

## Funkcija tr() vrsi transliteraciju teksta. Tekst je
## zadat stringom na koji pokazuje text. Pokazivaci
## orig i repl pokazuju na nizove znakova duzine n.
## Niz orig sadrzi znakove koje treba zameniti u tekstu,
## dok niz repl sadrzi znakove kojima treba zameniti 
## odgovarajuce znakove iz niza orig u tekstu. 

########################################################
## void tr(char *text, char orig[], char repl[], int n);
##
## [ebp+8]  -- char *text
## [ebp+12] -- char *orig
## [ebp+16] -- char *repl
## [ebp+20] -- int n
##
########################################################
tr:

## Prolog funkcije. Alociramo 256 bajta
## za tabelu transliteracije.
enter 256,0
push ebx
push esi
push edi


## Ideja: najpre cemo inicijalizovati tabelu transliteracije
## koja predstavlja niz karaktera duzine 256. Element na
## poziciji (i) u tom nizu ima vrednost karaktera kojim treba
## zameniti karakter sa vrednoscu (i) u tekstu. Inicijalno
## i-ti element postavljamo na vrednost (i) (identicko 
## preslikavanje). Nakon toga pozicije koje odgovaraju 
## karakterima navedenim u nizu orig zamenjujemo karakterima
## navedenim u nizu repl, na odgovarajucim mestima. 
## Kada je tabela ovako inicijalizovana, samo treba proci
## kroz ceo tekst i svaki karakter zameniti vrednoscu iz
## tabele.

## Postavljamo smer kretanja kroz string sa leva u desno.
cld

## U registar edi smestamo adresu pocetka tabele. U
## registar eax upisujemo nulu. Ovaj registar ce nam
## biti brojac u petlji koja sledi. Njegova vrednost
## ce se kretati od 0 do 255, i u svakoj iteraciji
## cemo i-ti element tabele postaviti na vrednost
## (i) (identicko preslikavanje). U registar edx 
## smestamo 256 (gornja granica vrednosti brojaca).
lea edi, [ebp-256]
xor eax,eax
mov edx,256

## Petlja u kojoj inicijalizujemo tabelu tako da je
## bajt na i-toj poziciji jednak (i), za svako (i),
## 0 <= i < 256.
next_position:
cmp eax,edx
jge continue
stosb
inc eax
jmp next_position

continue:

## Dalje, zelimo da tabelu modifikujemo tako
## da za svako (k), 0 <= k < n, element 
## tabele na poziciji orig[k] zamenimo vrednoscu
## repl[k]. U esi smestamo adresu niza orig.
## U edi smestamo adresu niza repl. U ecx
## smestamo broj karaktera u nizovima orig
## i repl (tj. n). U registar ebx smestamo
## adresu tabele transliteracije. Ovaj registar
## se inace implicitno koristi kao bazni registar
## za instrukciju xlatb.
mov esi, [ebp+12]
mov ecx, [ebp+20]
mov edi, [ebp+16]
lea ebx, [ebp-256]


## Anuliramo eax, zato sto je nakon izlaska
## iz gornje petlje dobio vrednost 256, tj.
## najnizi bit drugog bajta (ah) je postavljen
## na 1. Ovo verovatno ne bi smetalo, zato
## sto u nastavku programa koristimo iskljucivo
## al, ali ne moze da skodi.
xor eax,eax

## Registar edx postavljamo na 0. Koristicemo
## ga kao indeks za pristup tabeli.
xor edx,edx

## U ovoj petlji ucitavamo karakter iz niza
## orig u al, zatim  ga iz al prebacujemo u dl.
## Nakon toga u  al ucitavamo karakter iz niza 
## repl (u tu svrhu vrsimo zamenu vrednosti esi
## i edi registara, zato sto lodsb cita sa esi
## adrese). Na kraju element na odgovarajucoj
## poziciji u tabeli (tj. dl, a to je upravo
## pozicija koja je odredjena karakterom iz
## niza orig koji definise karaktere koje treba
## zmeniti u tekstu) zamenjujemo  karakterom 
## iz al (koji je iz niza repl). Ova petlja se
## vrti (n) puta, za svaki par karaktera iz nizova
## orig i repl po jednom.
next_tr:
lodsb
mov dl,al
xchg esi,edi
lodsb
xchg esi,edi
mov [ebx+edx],al
loop next_tr


## Na kraju je potrebno proci kroz tekst i na osnovu
## malopre inicijalizovane tabele transliteracije
## zameniti karaktere u stringu karakterima sa 
## odgovarajucih pozicija u tabeli. U esi i edi
## smestamo adresu stringa - to nam je i izvorni
## i odredisni string. U petlji ucitavamo karakter
## po karakter u al, instrukcijom xlatb ga zamenjujemo
## karakterom iz tabele, a zatim ga vracamo u string,
## instrukcijom stosb. Petlja se vrti dok se ne naidje
## na 0 bajt, sto je indikator kraja stringa text.
mov esi, [ebp+8]
mov edi, [ebp+8]
next_char:
lodsb
cmp al,0
je done
xlatb
stosb
jmp next_char

done:

## Epilog funkcije
pop edi
pop esi
pop ebx
leave
ret
