#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

#define MAX_STR 256 /* Maksimalna duzina teksta */

/* Deklaracija asemblerske funkcije */
void tr(char *text, char *orig, char *repl, int n);

int main()
{

char text[MAX_STR];
char orig[MAX_STR];
char repl[MAX_STR];
int n;
int text_len, orig_len, repl_len;


/* Ucitavamo tekst */
assert(fgets(text, MAX_STR, stdin) != NULL); 

/* Racunamo duzinu teksta. Ovo nam je potrebo
   da bismo eventualni znak za novi red sa kraja
   obrisali (tj. zamenili ga sa '\0') */
text_len = strlen(text);

/* Zamenjujemo eventualni '\n' sa '\0' */
if(text[text_len - 1] == '\n')
 text[--text_len] = '\0';

/* Ucitavamo orig */
assert(fgets(orig,MAX_STR,stdin) != NULL);

/* Racunamo duzinu stringa orig */
orig_len = strlen(orig);

/* Zamenjujemo eventualni '\n' sa '\0' */
if(orig[orig_len - 1] == '\n')
 orig[--orig_len] = '\0';

/* Ucitavamo repl */
assert(fgets(repl,MAX_STR,stdin) != NULL);

/* Racunamo duzinu stringa repl */
repl_len = strlen(repl);

/* Zamenjujemo eventualni '\n' sa '\0' */
if(repl[repl_len - 1] == '\n')
 repl[--repl_len] = '\0';

/* n = min(orig_len, repl_len); */
n = orig_len < repl_len ? orig_len : repl_len;

/* Vrsimo transliteraciju */
tr(text, orig, repl, n);

/* Prikazujemo izmenjeni tekst */
printf("%s\n", text);

return EXIT_SUCCESS;

}
