.intel_syntax noprefix

.data 
ppmsg: .asciz "Parend id (from parent): %d\n"
pcmsg: .asciz "Parent id (from child): %d\n"
ccmsg: .asciz "Child id (from child): %d\n"
cpmsg: .asciz "Child id (from parent): %d\n"

.text

.global main

main:

## Prolog funkcije
enter 0,0
pusha


## Pozivamo fork() sistemski poziv
mov eax, 2
int 0x80

## Poredimo povratnu vrednost fork-a sa 0. 
## fork() vraca 0 u child-u, vrednost 
## razlicitu od nule u parent-u. 
cmp eax, 0
je child

## U parent-u...
parent:

## Pozivamo getpid() da nam vrati PID parent procesa.
## Prethodno cuvamo vrednost eax, zato sto zelimo da
## kasnije iskoristimo vrednost koju je fork() vratio.
push eax
mov eax, 20
int 0x80

## Pozivamo printf() da nam ispise parend PID
push eax
lea eax, ppmsg
push eax
call printf
add esp,8

## Pozivamo printf() da nam ispise child PID
## Child PID je vec na steku, jer je to upravo
## vrednost koju fork() vraca parent-u, a koju
## smo malo pre sacuvali na steku.
lea eax, cpmsg
push eax
call printf
add esp,8
jmp done


## U child-u...
child:


## Pozivamo getppid() da nam vrati parent PID
mov eax, 64
int 0x80

## Pozivamo printf() da nam prikaze parent PID.
push eax
lea eax,pcmsg
push eax
call printf
add esp,8

## Pozivamo getpid() da nam vrati PID child-a.
mov eax, 20
int 0x80

## Pozivamo printf() da nam prikaze child PID.
push eax
lea eax, ccmsg
push eax
call printf
add esp,8


done:

## Epilog funkcije
popa
leave
ret
