.intel_syntax noprefix


.text
.global print_bits


###################################
#### void print_bits(int x)    ####
##
## [ebp+8] -- int x 
##
###################################
print_bits:

## Prolog funkcije
enter 0,0
push esi
push edi
push ebx

## Ucitavamo broj x u esi
mov esi, [ebp+8]

## Postavljamo ecx na 32 (ekvivalentno sa mov ecx,32)
## Ecx ce nam biti brojac u petlji. Zelimo 32 itera-
## cije, za svaki bit broja x po jednu.
xor ecx,ecx
bts ecx,5

## Postavljamo edi na 10000...00000 (32 bita)
## Ovo ce nam biti maska za testiranje bita
xor edi,edi
bts edi,31

## Anuliramo ebx. Ovaj registar cemo koristiti
## kao argument funkcije putchar(). Pri tom 
## cemo karakter '0' ili '1' da upisujemo u
## njegov najnizi bajt, bl.
xor ebx,ebx

## Petlja u kojoj se ocitava bit po bit, a
## zatim se ispisuje na izlaz, funkcijom
## putchar().
next_bit:

## Testiramo tekuci bit i postavljamo 
## registar dl na 0 ili 1 u zavisnosti
## od vrednosti testiranog bita.
test esi,edi
setnz bl

## Dodajemo ASCII kod '0', kako bismo dobili
## ASCII kod '0' ili '1' koji treba predati
## funkciji putchar().
add bl,'0'

## Poziv funkcije putchar(ebx). Pre poziva na
## stek cuvamo vrednost registra ecx, zato sto
## funkcija putchar() unistava registar ecx.
push ecx
push ebx
call putchar
add esp,4
pop ecx

## pomeramo jedinicu u edi registru za jednu
## poziciju u desno, kako bismo testirali sledeci
## bit
shr edi

loop next_bit

## Epilog funkcije
pop ebx
pop edi
pop esi
leave
ret
