.intel_syntax noprefix

.data
header:
.asciz "                    ODITSZ   P C\n"

.text
.global main

main:

## Prolog funkcije
enter 0,0
pusha


## Program demonstrira ocitavanje i 
## manipulaciju flegovima u eflags 
## registru.

## Prikazujemo najpre "zaglavlje" tabele
lea eax,header
push eax
call printf
add esp,4

## Postavljamo na stek eflags, i 
## pozivamo funkciju print_bits
## koja prikazuje sadrzaj na izlazu.
pushfd
call print_bits

## Pozivamo funkciju putchar('\n').
xor eax,eax
mov al, '\n'
push eax
call putchar
add esp,4

## Vracamo ranije ocitane flegove
## u eflags registar. Ovo je bitno,
## zato sto smo u medjuvremenu obavljali
## neke operacije, i pozivali funkciju
## putchar() sto je verovatno promenilo
## flegove.
popfd

## Sada menjamo originalni sadrzaj eflags
## registra, instrukcijama za manipulaciju
## flagovima. Flag CF se komplementira.
## Flag DF se postavlja na 1.
cmc
std

## Sada proveravamo da smo zaista izvrsili 
## gornje promene na eflags registru, tako
## sto njegov novi sadrzaj postavljamo na
## stek, i pozivamo funkciju print_bits().
pushfd
call print_bits

## Pozivamo putchar('\n');
xor eax,eax
mov al,'\n'
push eax
call putchar
add esp,4

## Kao i ranije, vracamo upravo ispisani
## sadrzaj eflags registra, jer je sadrzaj
## u medjuvremenu verovatno promenjen,
## usled izvrsenja raznih instrukcija.
popfd

## U nastavku zelimo da komplementiramo
## flegove SF (7) i OF (11). Kako za ove
## flegove ne postoje direktne instrukcije
## za manipulaciju, moramo da najpre ucitamo
## eflags registar u eax, i da zatim bitovskim
## instrukcijama na registru eax izvrsimo
## promene. Nakon toga cemo vratiti izmenjeni
## sadrzaj u eflags. S obzirom da ne postoji
## mogucnost da mov instrukcijom prebacimo
## direktno eflags u eax, ili obrnuto, moramo
## da transfer obavimo preko steka.
pushfd
pop eax
btc eax,7
btc eax,11
push eax
popfd

## Sada se kao i malo cas, uveravamo da smo 
## zaista izvrsili zeljene promene, ocitavanjem
## sadrzaja eflags registra, i ispisivanjem istog
## na izlaz.
pushfd
call print_bits
add esp,4

## pozivamo putchar('\n');
xor eax,eax
mov al,'\n'
push eax
call putchar
add esp,4

## Epilog funkcije
popa
leave
ret
