.intel_syntax noprefix
		
.data
table:				# Tabela konverzije
	.fill	48, 1, 0
	.byte	'4','5','9','0','8','2','1','3','6','7'
	.fill	7, 1, 0
	.byte	'G','V','H','Z','U','S','O','B','M','I','K','P','J'
        .byte   'C','A','D','L','F','T','Y','E','Q','N','W','X','R'
	.fill	6, 1, 0
	.byte	'g','v','h','z','u','s','o','b','m','i','k','p','j'
        .byte   'c','a','d','l','f','t','y','e','q','n','w','x','r'
	.fill	133, 1, 0
wrfmt:	.asciz  "%s\n"		# Izlazni format.

.bss
.lcomm	msg, 80			# Poruka koja se sifruje.
		
.text
.global main

main:
	## Prolog funkcije.
	enter   0, 0
	pusha

	## Ucitava se poruka sa standardnog ulaza. Radi jednostavnosti
	## je za ucitavanje stringa koriscena gets() funkcija;
	## pretpostavka je da uneseni stringovi nece biti duzi od 79
	## karaktera. Ovu funkciju zbog mogucnosti buffer overflow-a
        ## inace NIKAD ne treba upotrebljavati, vec umjesto nje treba
	## koristiti fgets() funkciju.
	lea	eax, msg
	push	eax
	call gets
	add	esp, 4

	## Izracunava se duzina poruke. U registar al se stavlja
	## vrijednost koja se trazi odn. 0 (kojom je terminiran string).
	## U registar ecx se stavlja maksimalna duzina stringa, a u
	## registar edi adresa prvom karaktera u stringu. Potom se scasb
	## instrukcija ponavlja dok se ne dodje do kraja stringa, a onda
	## se od 79 (za 1 manje od vrijednosti prvobitno ucitane u
	## registar ecx zato sto se pri primjeni rep prefiksa uvijek
	## prvo dekrementira ovaj registar, pa tek onda ispituju uslovi
	## izlaska iz petlje) oduzme sadrzaj registra ecx i na taj nacin
	## se dolazi do duzine stringa.
	cld
	xor	al, al
	mov	ecx, 80
	lea	edi, msg
	repnz scasb
	sub	ecx, 79
	neg	ecx

	## Ako je duzina poruke 0, odmah se prelazi na stampanje.
	jecxz print

	## Sifruje se poruka. U registru ebx se drzi adresa prvog
	## karaktera tabele sifrovanja, a registri esi i edi sadrze
	## adresu tekuceg karaktera poruke.
	lea	ebx, table
	lea	esi, msg
	mov	edi, esi
	
next_char:
	## Ucitava se tekuci karakter iz poruke i pronalazi njegova
	## zamjena u tabeli, koja se potom upisuje namjesto karaktera u
	## poruci, Ako je zamjena jednaka 0, znaci da nije u pitanju
	## alfanumericki karakter i onda se samo prelazi na naredni
	## karakter u poruci.
	lodsb
	xlatb
	cmp	al, 0
	je special
	stosb
	jmp continue
special:
	inc	edi
continue:
	loop next_char

print:
	## Ispisuje se sifrovana poruka na standardni izlaz.
	lea	eax, msg
	push	eax
	lea	eax, wrfmt
	push	eax
	call printf
	add	esp, 8
	
	## Epilog funkcije.
	popa
	xor	eax, eax
	leave
	ret
