.intel_syntax noprefix
		
.data
wrfmt:	.asciz  "%s\n"		# Izlazni format.

.bss
.lcomm	id, 13			# Identifikacioni string proizvodjaca procesora.
		
.text
.global main

main:
	## Prolog funkcije.
	enter   0, 0
	pusha

	## Provjerava se da li procesor podrzava cpuid
	## instrukciju. Sadrzaj eflags registra se preko steka prebacuje u
	## registar eax, a onda se testira i komplementira vrijednost
	## bita koji odgovara identification flegu.  Prethodna vrijednost
        ## flega se pamti u bl registru.  Potom se nova vrijednost vraca
	## u eflags registar, da bi se odmah zatim na isti nacin kao
	## gore ocitala nova vrijednost eflags registra u registar eax
	## odnosno identification flega u registar bh.  Na kraju se
	## porede stara i nova vrijednost flega iz registara bl i bh.
	## Ukoliko se vrijednosti razlikuju, znaci da je promjena
	## vrijedosti identification flega uspjela, odn. da procesor
	## podrzava cpuid instrukciju.
	pushfd
	pop	eax
        btc     eax, 21
        setc    bl
	push	eax
	popfd
	pushfd
	pop	eax
        bt      eax, 21
        setc    bh
        cmp     bh, bl
	je done

	## Ocitava se identifikacioni string proizvodjaca procesora.
	xor     eax, eax
	cpuid

	## Prebacuje se identifikacioni string u memoriju. Prva 4
	## karaktera ovog stringa se po izvrsenju cpuid instrukcije
	## nalaze u registru ebx, naredna 4 u registru edx i poslednja 4
	## u registru ecx.
	mov	id, ebx
	mov	id+4, edx
	mov	id+8, ecx
	mov	byte ptr id+12, 0

	## Stampa se identifikacioni string.
	lea	eax, id
	push	eax
	lea	eax, wrfmt
	push	eax
	call printf
	add	esp, 8

done:
	## Epilog funkcije.
	popa
	xor	eax, eax
	leave
	ret
