.intel_syntax noprefix


.text
.global untouchable

###########################################################################
##
## Funkcija ispituje da li je dati prirodan broj x nedodirljiv. Broj x je
## nedodirljiv ako ne postoji prirodan broj n takav da je zbir njegovih
## pravih delilaca jednak broju x. Ako je broj nedodirljiv,funkcija vraca 0.
## U suprotnom, vraca najmanji broj n koji zadovoljava opisano svojstvo.
##	
## int untouchable(int x);
##
## -- int x -- [ebp+8] -- broj za koji se ispituje nedodirljivost.
##########################################################################

untouchable:
	## Prolog funkcije
	enter 0,0
	push edi
	push esi
	push ebx

	## Ideja algoritma: moze se pokazati da ako je x != 1 i ako je
	## broj n takav da je zbir njegovih pravih delilaca jednak x,
	## tada vazi n < x^2. Otuda je dovoljno proveriti za sve brojeve
	## n, 2 <= n < x^2 da li je zbir njihovih pravih delilaca jednak
	## x. Ako nije, broj je nedodirljiv.
	
	## Ucitavamo broj x u ebx.
	mov ebx, [ebp+8]

	## Slucaj jedinice: vracamo broj 2 (jer je jedini pravi delilac
	## dvojke upravo 1).
	cmp ebx, 1
	je one

	## U suprotnom racunamo x^2 i smestamo ga u edi.
	mov eax, ebx
	mul ebx
	mov edi, eax

	## Registar ecx ce nam sadrzati tekuce n.
	mov ecx, 1
next_n:
	## Racunamo sledece n, i ispitujemo da li je n < x^2
	inc ecx
	cmp ecx, edi
	jae not_found

	## Potiskujemo na stek tekucu vrednost n, zato sto cemo ecx
	## koristiti kao brojac u unutrasnjoj petlji.
	push ecx

	## Najveci pravi delilac broja n ne moze biti veci od [n/2]. Zato
	## inicijalizujemo p = [n/2]. U svakoj iteraciji cemo proveravati
	## da li je n deljivo sa p (ako jeste, dodavacemo p na sumu
	## delilaca) a zatim cemo p umanjivati za jedan. U poslednjoj
	## iteraciji broj p ce imati vrednost 1. Broj p cemo cuvati u
	## registru ecx.
	shr ecx, 1

	## Registar esi ce nam cuvati sumu pravih delilaca broja n.
	xor esi, esi
	
check_next:
	## Ispitujemo da li je n deljivo sa p.
	mov eax, [esp]
	xor edx, edx
	div ecx
	cmp edx, 0
	je found_divisor
	jmp prepare_next

	## Ako je deljiv, tada treba dodati p na sumu delilaca broja n.
found_divisor:
	add esi, ecx
	jmp prepare_next

	## Prelazimo na sledece p.
prepare_next:	
	loop check_next

	## Vracamo n u ecx.
	pop ecx

	## Ako je suma pravih delilaca broja n jednaka broju x, tada broj
	## nije nedodirljiv. Vracamo nadjeni broj n. U suprotnom prelazimo
	## na sledeci broj n.
	cmp esi, ebx
	jne next_n
	jmp found
	
found:
	## Prebacujemo n u eax.
	mov eax, ecx
	jmp done
	
not_found:
	## Vracamo nulu.
	xor eax, eax
	jmp done
	
one:
	## Slucaj jedinice: vracamo 2.
	mov eax, 2
	jmp done
	
done:	
	## Epilog funkcije
	pop ebx
	pop esi
	pop edi
	leave
	ret
	