#include <stdio.h>
#include <stdlib.h>
#include <assert.h>


/* Deklaracija asemblerske funkcije */
void quadratic_form(int n, float **a, float *x, float * f);

/* Test program */
int main()
{
  int n;        /* Dimenzija matrice */
  float **a;    /* Pokazivac na niz pokazivaca na vrste matrice */
  float *x;     /* Pokazivac na vektor x */
  float f;      /* Rezultat */ 
  int i, j;     /* Indeksi u petljama */
  
  /* Ucitavamo dimenziju matrice */
  assert(scanf("%d", &n) == 1);
  assert(n > 0);

  /* Alociramo prostor za matricu, kao i za vektor x */
  assert((a = malloc(sizeof(float *) * n)) != NULL);  
  for(i = 0; i < n; i++)
    assert((a[i] = malloc(sizeof(float) * n)) != NULL);
  assert((x = malloc(sizeof(float) * n)) != NULL);
  
  /* Ucitavamo matricu */
  for(i = 0; i < n; i++)
    for(j = 0; j < n; j++)
      assert(scanf("%f", &a[i][j]) == 1);
  
  /* Ucitavamo vektor x */
  for(j = 0; j < n; j++)
    assert(scanf("%f", &x[j]) == 1);
  
  /* Pozivamo asemblersku funkciju */
  quadratic_form(n, a, x, &f);
  
  /* Prikazujemo rezultat */
  printf("%f\n", f);

  /* Oslobadjamo alocirani prostor */
  free(x);
  for(i = 0; i < n; i++)
    free(a[i]);
  free(a);

  return EXIT_SUCCESS;
}
