﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;

namespace SocialNetwork.Models
{
    public class UserProfileViewModel
    {
        private ApplicationDbContext context = new ApplicationDbContext();
        public ApplicationUser User { get; set; }

        public IEnumerable<Post> Posts
        {
            get
            {
                return (from p in context.Posts
                        where p.UserId == User.Id
                        orderby p.Time descending
                        select p);
            }
        }

        [Required]
        [Display(Name="What's on your mind:")]
        public string Text { get; set; }

    }
}