﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;
namespace SocialNetwork.Models
{
    public class UserListViewModel
    {
        private ApplicationDbContext context = new ApplicationDbContext();
        public ApplicationUser CurrentUser { set; get; }
        

        public IEnumerable<ApplicationUser> Users
        {
            get
            {
                return from user in context.Users
                       where (Text == null || user.FirstName.Contains(Text) || user.LastName.Contains(Text)) &&
                              (Gender == "all" || (Gender == "female" && user.Gender == Models.Gender.Female) 
                              || (Gender == "male" && user.Gender == Models.Gender.Male))
                       select user;
            }
        }
        
        public bool isFollowed(string user_id)
        {
            return (from user in CurrentUser.Following
                    where user.Id == user_id
                    select user).Any();
        }

        public IEnumerable<SelectListItem> GenderList
        {
            get
            {
                return new List<SelectListItem>() { new SelectListItem() { Value = "all", Text = "all" }, 
                                                    new SelectListItem() { Value = "female", Text = "female" },
                                                    new SelectListItem() { Value = "male", Text = "male" }
                                                   };
            }
        }

        [Display(Name="Name: ")]
        public string Text
        {
            set;
            get;
        }

        [Required]
        [Display(Name="Gender: ")]
        public string Gender
        {
            set;
            get;
        }

    }
}