﻿using Microsoft.AspNet.Identity.EntityFramework;
using System.Data.Entity;
using Microsoft.AspNet.Identity;
using Microsoft.Owin.Security;
using System.Collections.Generic;
using System;

namespace SocialNetwork.Models
{
    public enum Gender { Female, Male };

    // You can add profile data for the user by adding more properties to your ApplicationUser class, please visit http://go.microsoft.com/fwlink/?LinkID=317594 to learn more.
    public class ApplicationUser : IdentityUser
    {
        public string FirstName { set; get; }
        public string LastName { set; get; }

        public Gender Gender { set; get; }

        public int YearOfBirth { set; get; }

        virtual public ICollection<ApplicationUser> Following { set; get; }

        virtual public ICollection<ApplicationUser> FollowedBy { set; get; }

        virtual public ICollection<Post> Posts { set; get; }

    }

    public class Post
    {
        public int Id { set; get; }
        public string Text { set; get; }
        public DateTime Time { set; get; }

        virtual public string UserId { set; get; }

        virtual public ApplicationUser User { set; get; }
    }

    public class ApplicationDbContext : IdentityDbContext<ApplicationUser>
    {
        public ApplicationDbContext()
            : base("DefaultConnection")
        {
        }

        public DbSet<Post> Posts { set; get; }

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            modelBuilder.Entity<ApplicationUser>().HasMany(x => x.Following).WithMany(x => x.FollowedBy);
            modelBuilder.Entity<Post>().HasKey(x => x.Id).HasRequired(x => x.User).WithMany(x => x.Posts).HasForeignKey(x => x.UserId).WillCascadeOnDelete(false);
            //modelBuilder.Entity<ApplicationUser>().HasMany(x => x.Posts).WithRequired(x => x.User).HasForeignKey(x => x.UserId).WillCascadeOnDelete(false);
            
            base.OnModelCreating(modelBuilder);
        }
    }
}