﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace SocialNetwork.Models
{
    public class HomePageViewModel
    {
        private ApplicationDbContext context = new ApplicationDbContext();
        public ApplicationUser User { get; set; }


        public IEnumerable<Post> Posts
        {
            get
            {
                var following = (from u in User.Following
                                 select u.Id);

                var res = (from p in context.Posts
                           where (from f in following 
                                  where f == p.UserId
                                  select f).Any()
                           orderby p.Time descending
                           select p);
                return res;
            }
        }
    }
}