﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.EntityFramework;
using Microsoft.Owin.Security;
using SocialNetwork.Models;

namespace SocialNetwork.Controllers
{
    [Authorize]
    public class UserController : Controller
    {
        public ApplicationDbContext Context { set; get; }


        public UserManager<ApplicationUser> Manager { set; get; }

        public UserController()
        {
            Context = new ApplicationDbContext();
            Manager = new UserManager<ApplicationUser>(new UserStore<ApplicationUser>(Context));
        }

        public ApplicationUser CurrentUser
        {
            get
            {
                ApplicationUser user = Manager.FindByName(User.Identity.Name);
                return user;
            }
        }

        public ApplicationUser GetUser(string user_id)
        {
            ApplicationUser user = Manager.FindById(user_id);
            return user;
        }

        //
        // GET: /User/
        public ActionResult Profile(string id)
        {
            if (id != null && id != "")
            {
                ApplicationUser user = GetUser(id);
                if (user != null)
                {
                    UserProfileViewModel model = new UserProfileViewModel();
                    model.User = user;
                    return View(model);
                }
                else
                {
                    return RedirectToAction("Error", new { Message = "Unknown user", RedirectAction = "Index", RedirectController = "Home" });
                }
            }
            else
            {
                UserProfileViewModel model = new UserProfileViewModel();
                model.User = CurrentUser;
                return View(model);
            }
           
        }

        public ActionResult List()
        {
            UserListViewModel model = new UserListViewModel();
            model.CurrentUser = CurrentUser;
            model.Gender = "all";
            return View(model);
        }

        [HttpPost]
        public ActionResult List(UserListViewModel model)
        {
            model.CurrentUser = CurrentUser;
            return PartialView("_PartialList", model);
        }
        
        [HttpPost]
        public ActionResult Follow(string id)
        {
            if (id != null && id != "")
            {
                ApplicationUser user = GetUser(id);
                if (user != null)
                {
                    using(var tr = Context.Database.BeginTransaction())
                    {
                        try
                        {
                            CurrentUser.Following.Add(user);
                            user.FollowedBy.Add(CurrentUser);
                            Manager.Update(CurrentUser);
                            Manager.Update(user);
                            tr.Commit();
                            return Json(new { done = true });
                        }
                        catch (Exception e)
                        {
                            tr.Rollback();
                            return Json(new { done = false, message = e.Message });
                        }
                    }
                    
                } 
            }
  
           return Json(new { done = false, message = "Unknown user" });
        }

        [HttpPost]
        public ActionResult Unfollow(string id)
        {
            if (id != null && id != "")
            {
                ApplicationUser user = GetUser(id);
                if (user != null)
                {
                    using(var tr = Context.Database.BeginTransaction())
                    {
                        try
                        {
                            CurrentUser.Following.Remove(user);
                            user.FollowedBy.Remove(CurrentUser);
                            Manager.Update(CurrentUser);
                            Manager.Update(user);
                            tr.Commit();
                            return Json(new { done = true });
                        }
                        catch (Exception e)
                        {
                            tr.Rollback();
                            return Json(new { done = false, message = e.Message });
                        }
                    }
                   
                }
            }

            return Json(new { done = false, message = "Unknown user" });
        }

        public ActionResult Error(string Message, string RedirectAction, string RedirectController)
        {
            ViewBag.Message = Message;
            ViewBag.Action = RedirectAction;
            ViewBag.Controller = RedirectController;
            return View("~/Views/Shared/Error.cshtml");
        }
	}
}