﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.EntityFramework;
using Microsoft.Owin.Security;
using SocialNetwork.Models;

namespace SocialNetwork.Controllers
{
    [Authorize]
    public class PostController : Controller
    {
         public ApplicationDbContext Context { set; get; }


        public UserManager<ApplicationUser> Manager { set; get; }

        public PostController()
        {
            Context = new ApplicationDbContext();
            Manager = new UserManager<ApplicationUser>(new UserStore<ApplicationUser>(Context));
        }

        public ApplicationUser CurrentUser
        {
            get
            {
                ApplicationUser user = Manager.FindByName(User.Identity.Name);
                return user;
            }
        }

        //
        // GET: /Post/
        public ActionResult Add(string Text)
        {
            if (ModelState.IsValid)
            {
                Post post = new Post() { Time = DateTime.Now, User = CurrentUser, Text = Text };
                Context.Posts.Add(post);
                Context.SaveChanges();
                var data = new { Time = DateTime.Now.ToString(), UserName = CurrentUser.UserName, Text };
                return Json(data);
            }
            return View();
        }

	}
}