﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;

namespace WebApplication1.Models
{
    public class UserListViewModel
    {
        private ApplicationDbContext context = new ApplicationDbContext();

        public bool IsFollowed(string currentUsername, string id)
        {
            ApplicationUser CurrentUser = (from u in context.Users
                                           where u.UserName == currentUsername
                                           select u).First();
            return (from u in CurrentUser.Following
                    where u.Id == id
                    select u).Any();
        }

        public IEnumerable<ApplicationUser> Users
        {
            get
            {
                return (from user in context.Users
                        where (Text == null || Text == "" || user.FirstName.Contains(Text) ||
                              user.LastName.Contains(Text) ||
                              user.UserName.Contains(Text)) &&
                              (UserGender == "all" || (UserGender == "Male" && user.UserGender == Gender.Male)
                              || (UserGender == "Female" && user.UserGender == Gender.Female))
                        select user);
            }
        }

        public List<SelectListItem> GenderList
        {
            get
            {
                return new List<SelectListItem>()
                {
                    new SelectListItem() { Value = "all", Text = "all"},
                    new SelectListItem() { Value = "Female", Text = "female"},
                    new SelectListItem() { Value = "Male", Text = "male"}
                };
            }
        }

        [Display(Name="Search: ")]
        public string Text
        {
            set;
            get;
        }

        [Required]
        [Display(Name="Gender: ")]
        public string UserGender { set; get; }

    }
}