﻿using Microsoft.AspNet.Identity.EntityFramework;
using System.Collections.Generic;


namespace WebApplication1.Models
{
    public enum Gender {
        Female,
        Male
    }

    // You can add profile data for the user by adding more properties to your ApplicationUser class, please visit http://go.microsoft.com/fwlink/?LinkID=317594 to learn more.
    public class ApplicationUser : IdentityUser
    {
        public string FirstName { set; get; }
        public string LastName { set; get; }
        public Gender UserGender { set; get; }

        public int YearOfBirth { set; get; }

        public virtual ICollection<ApplicationUser> Following { set; get; }
        public virtual ICollection<ApplicationUser> FollowedBy { set; get; }

    }

    public class ApplicationDbContext : IdentityDbContext<ApplicationUser>
    {
        public ApplicationDbContext()
            : base("DefaultConnection")
        {
        }

        protected override void OnModelCreating(System.Data.Entity.DbModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);
            modelBuilder.Entity<ApplicationUser>().HasMany(x => x.Following).WithMany(x => x.FollowedBy);
        }
    }
}