﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.EntityFramework;
using Microsoft.Owin.Security;
using WebApplication1.Models;

namespace WebApplication1.Controllers
{
    [Authorize]
    public class UserController : Controller
    {

        public ApplicationDbContext Context { set; get; }

         public UserManager<ApplicationUser> UserManager { set; get; } 

        public UserController()
        {
            Context = new ApplicationDbContext();
            UserManager = new UserManager<ApplicationUser>(new UserStore<ApplicationUser>(Context));
        }

        public ApplicationUser CurrentUser {
            get
            {
                if (User.Identity.IsAuthenticated)
                {
                    return UserManager.FindByName(User.Identity.Name);
                }
                else
                    return null;
            }
    }

        //
        // GET: /User/
        public ActionResult Profile(string id)
        {
            if (id == null || id == "")
            {
                return View(CurrentUser);
            }
            else
            {
                ApplicationUser user = UserManager.FindById(id);

             /*   user = (from u in Context.Users
                        where u.Id == id
                        select u).First(); */
                if(user == null)
                {
                    return RedirectToAction("Error", new { Message = "User does not exist", ReturnAction = "Index", ReturnController = "Home" });
                }
                else
                {
                    return View(user);
                }
            }
            return View();
        }

        [HttpGet]
        public ActionResult List()
        {
            UserListViewModel model = new UserListViewModel();
            model.UserGender = "all";
            model.Text = "";
            return View(model);
        }

        [HttpPost]
        public ActionResult List(UserListViewModel model)
        {
            return PartialView("_ListPartial", model);
        }

        [HttpPost]
        public ActionResult Follow(string id)
        {
            if(id != null && id != "")
            {
                ApplicationUser user = UserManager.FindById(id);
                if(user != null)
                {
                    using (var tr = Context.Database.BeginTransaction())
                    {
                        try
                        {
                            bool followed = (from u in CurrentUser.Following
                                             where u.Id == id
                                             select u).Any();
                            if (!followed)
                            {
                                user.FollowedBy.Add(CurrentUser);
                                CurrentUser.Following.Add(user);

                            }
                            else
                            {
                                user.FollowedBy.Remove(CurrentUser);
                                CurrentUser.Following.Remove(user);
                            }
                            UserManager.Update(CurrentUser);
                            UserManager.Update(user);
                            tr.Commit();
                            return Json(new { Done = true, Followed = !followed });
                        }
                        catch (Exception e)
                        {
                            tr.Rollback();
                            return Json(new { Done = false, Message = e.Message });
                        }
                    }
                }
                else
                {
                    return Json(new { Done = false, Message = "Invalid user" });
                }
            }
            else
            {
                var ret = new { Done = false, Message = "Unspecified user" };
                return Json(ret);
            }
        }

        

        public ActionResult Error(string Message, string ReturnAction, string ReturnController)
        {
            ViewBag.Message = Message;
            ViewBag.ReturnAction = ReturnAction;
            ViewBag.ReturnController = ReturnController;
            return View();
        }

	}
}