﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.EntityFramework;
using Microsoft.Owin.Security;
using WebApplication1.Models;

namespace WebApplication1.Controllers
{
    [Authorize]
    public class HomeController : Controller
    {
        public UserManager<ApplicationUser> UserManager { set; get; } 

        public HomeController()
        {
            UserManager = new UserManager<ApplicationUser>(new UserStore<ApplicationUser>(new ApplicationDbContext()));
        }

        public ApplicationUser CurrentUser {
            get
            {
                if (User.Identity.IsAuthenticated)
                {
                    return UserManager.FindByName(User.Identity.Name);
                }
                else
                    return null;
            }
    }


        public ActionResult Index()
        {
            ViewBag.User = CurrentUser;

            return View();
        } 
    }
}