/* Program definise apstraktni tip Broj koji predstavlja veliki pozitivan
   ceo broj, a zatim i nekoliko funkcija za rad sa ovakvim brojevima. */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define MAX_CIFRE 100


/* Definicija apstraktnog tipa Broj */
typedef struct broj
{
  int cifre[MAX_CIFRE];
  int duzina;
} Broj;


/* Funkcija brise eventualne vodece nule. */
void obrisi_vodece (Broj *b)
{
  /* brisu se sve vodece nule, osim u slucaju da je broj
     sastavljen od svih nula, tada se ostavlja samo jedna */
  while (b->duzina > 1 && b->cifre[b->duzina - 1] == 0)
    b->duzina--;
}

/* Funkcija obrce cifre prosledjenog niza */
void obrni_cifre (int cifre[], int duzina)
{
  int i, j;

  for (i = 0, j = duzina - 1; i < j; i++, j--)
    {
      int pom = cifre[i];
      cifre[i] = cifre[j];
      cifre[j] = pom;
    }
}


/* Funkcija ucitava broj sa ulaza */
void ucitaj_broj(Broj *b)
{
  char c;
  
  for(b->duzina = 0; b->duzina < MAX_CIFRE && isdigit (c = getchar ()); 
      b->cifre[b->duzina++] = c - '0');

  /* inicijalizujemo broj nulom, ako nema cifara na ulazu */
  if (b->duzina == 0)
    b->cifre[b->duzina++] = 0;
  
  obrni_cifre (b->cifre, b->duzina);
  obrisi_vodece(b);

}

/* Funkcija ispisuje "veliki" broj na standardni izlaz */
void ispisi_broj(Broj * b)
{
  int i;
  for (i = b->duzina - 1; i >= 0; i--)
    printf ("%d", b->cifre[i]);
  putchar ('\n');
}


/* Funckija poredi dva broja a i b, i vraca 1 ako je a>b,
   0 ako je a==b, odnosno  -1 ako je b>a. */
int uporedi_brojeve(Broj * a, Broj * b)
{
  int i;

  /* Uporedjujemo duzine brojeva a i b */
  if (a->duzina > b->duzina)
    return 1;
  if (a->duzina < b->duzina)
    return -1;
  
  /* U ovom trenutku znamo da su brojevi iste duzine, tako da
     prelazimo na poredjenje cifre po cifre, pocevsi od cifre
     najvece tezine */
  for (i = a->duzina - 1; i >= 0; i--)
    {
      if (a->cifre[i] > b->cifre[i])
	return 1;
      if (a->cifre[i] < b->cifre[i])
	return -1;
    }
  return 0;
}

/* Funkcija sabira dva broja i vraca rezultat preko pokazivaca */
void saberi_brojeve(Broj * a, Broj * b, Broj * rezultat)
{
  int i;
  /* Prenos sa prethodne pozicije */
  int prenos = 0;

  /* Sabiranje vrsimo dok ne prodjemo sve cifre duzeg od brojeva a i b */
  for (i = 0; i < a->duzina || i < b->duzina; i++)

    {
      /* Sabiramo i-tu cifra broja a (ako postoji) sa i-tom cifrom
         broja b (ako postoji) i prenos sa prethodne pozicije */
      int cifra_rezulata = ((i < a->duzina) ? a->cifre[i] : 0) +
	((i < b->duzina) ? b->cifre[i] : 0) + prenos;
      /* Nova cifra rezultata */
      rezultat->cifre[i] = cifra_rezulata % 10;
      /* Prenos na sledecu poziciju */
      prenos = cifra_rezulata / 10;
    }
  /* Kada smo zavrsili sa svim ciframa brojeva a i b moguce je da je
     postojao prenos na sledecu poziciju u kom slucaju uvecavamo duzinu
     rezultata. Inace duzinu rezultata postavljamo na duzinu duzeg od
     brojeva a i b, koja se nalazi trenutno u promenjivoj i */
  if (prenos != 0 && i < MAX_CIFRE)
    {
      rezultat->cifre[i] = prenos;
      rezultat->duzina = i + 1;
    }
  else
    rezultat->duzina = i;
  
}


/* Funkcija mnozi broj datom cifrom  i rezultat upisuje na 
   lokaciju rezultat */
void pomnozi_cifrom(Broj * a, int cifra, Broj * rezultat)
{

  int i, prenos = 0;

  /* Ako je cifra nula, tada je rezultat 0 */ 
  if(cifra == 0)
    {
      rezultat->cifre[0] = 0;
      rezultat->duzina = 1;
      return;
    }

  for (i = 0; i < a->duzina; i++)
    {
      /* Svaku cifru broja a mnozimo cifrom c, dodajemo na to
         prenos sa prethodne pozicije i to smestamo u promenljivu
         pom */
      int pom = a->cifre[i] * cifra + prenos;
      
      /* Nova cifra rezultata */
      rezultat->cifre[i] = pom % 10;
      
      /* Prenos na sledecu poziciju */
      prenos = pom / 10;
    }
  
  /* Kada smo zavrsili sa svim ciframa broja a, moguce je da je
     postojao prenos na sledecu poziciju u kom slucaju uvecavamo
     duzinu rezultata. Inace duzinu rezultata postavljamo na duzinu
     broja a, koja se nalazi trenutno u promenjivoj i */
  if (prenos != 0 && i < MAX_CIFRE)
    {
      rezultat->cifre[i] = prenos;
      rezultat->duzina = i + 1;    
    }
  else
    rezultat->duzina = i;
  
}


/* Funkcija mnozi broj sa 10 na k, i rezultat smesta na 
   istu lokaciju. Koristi se za pojednostavljenje mnozenja */
void pomnozi_sa_10_na_k (Broj * b, int k)
{
  int i;
  
  /* nema svrhe mnoziti nulu sa 10 na k, jer bi to 
     dalo kao rezultat niz od k+1 nule. */
  if (b->duzina == 1 && b->cifre[0] == 0)
    return;
  
  /* nova duzina -- dodajemo k nula na kraj broja */
  b->duzina = k + b->duzina;
  
  /* prepisujemo cifre */
  for (i = b->duzina - 1; i >= 0; i--)
    b->cifre[i] = i < k ? 0 : b->cifre[i - k];
  
}

/* Funkcija mnozi dva broja i proizvod smesta na lokaciju
   rezultat. */
void pomnozi_brojeve(Broj * a, Broj * b, Broj * rezultat)
{
  /* Ova funkcija se gradi kombinovanjem algoritama mnozenja broja 
     cifrom i sabiranja dva broja */
  int i;

  /* Broj pom ce da sadrzi rezultat mnozenja broja a jednom po 
     jednom cifrom broja b, dok ce na broj rezultat da se dodaje 
     svaki put (10^i)*pom */

  Broj pom, novi_rezultat;
 
  /* Inicijalizujemo rezultat na nulu */
  rezultat->duzina = 1;
  rezultat->cifre[0] = 0;
  
  /* Za svaku cifru broja a */
  for (i = 0; i < a->duzina; i++)
    {
      /* vrsimo mnozenje broja b i-tom cifrom broja a */
      pomnozi_cifrom(b, a->cifre[i], &pom);
      
      pomnozi_sa_10_na_k (&pom, i);
      saberi_brojeve(rezultat, &pom, &novi_rezultat);
      *rezultat = novi_rezultat;
      
    }

}

/* Funkcija napravi_broj() kreira strukturu Broj koja
   sadrzi cifre broja n */
void napravi_broj (unsigned int n, Broj * rezultat)
{
  int i;
  
  /* 0 je specijalni slucaj */
  if (n == 0)
    {
      rezultat->duzina = 1;
      rezultat->cifre[0] = 0;
      return;
    }
  
  for (i = 0; n; i++, n /= 10)
    rezultat->cifre[i] = n % 10;
  
  rezultat->duzina = i;
  
}

/* Funkcija faktorijel() izracunava faktorijel
   broja n, i smesta ga na lokaciju rezultat. */
void faktorijel (int n, Broj * rezultat)
{
  Broj broj_i;
  Broj novi_rezultat;
  int i;
  
  /* Inicijalizujemo rezultat na  1 */
  rezultat->duzina = 1;
  rezultat->cifre[0] = 1;
  
  /* mnozimo 1*2*3*...*n */
  for(i=2;i<=n;i++)
    {
      /* kreiramo strukturu Broj koja predstavlja broj i */
      napravi_broj (i, &broj_i);
      
      /* mnozimo (n-1)! * n i to smestamo u novi_rezultat */
      pomnozi_brojeve (rezultat, &broj_i, &novi_rezultat);
      
      /* reinicijalizujemo rezultat */
      *rezultat = novi_rezultat;
    }
  
}

/* Funkcija fibonachi() racuna prvih n Fibonacijevih
   brojeva, koje smesta u niz struktura tipa Broj. */
void fibonachi (int n, Broj rezultat[])
{
  int i;
 /* inicijalizujemo prvi element Fibonacijevog niza na 1 */
      rezultat[0].duzina = 1;
      rezultat[0].cifre[0] = 1;
   
/* ako je n bar dva, inicijalizujemo i drugi na 1 */  
  if (n >= 2)
   {
      rezultat[1].duzina = 1;
      rezultat[1].cifre[0] = 1;
   }

/* za sve i, 3<=i<=n racunamo po rekurentnoj formuli */
 for(i=3;i<=n;i++)
  saberi_brojeve (&rezultat[i - 3], &rezultat[i - 2], &rezultat[i - 1]);

}

/* Test program */
int main ()
{

  Broj a, b, rezultat;
  Broj fib_niz[1000];
  int n, i;
  
  /* Unos velikih brojeva */
  printf("Unesite prvi broj : ");
  ucitaj_broj(&a);
  printf("Unesite drugi broj : ");
  ucitaj_broj(&b);

  /* Prikaz velikih brojeva */
  printf("a je: ");
  ispisi_broj(&a);
  printf("b je: ");
  ispisi_broj(&b);

  /* Sabiraju se i ispisuje se zbir */
  printf("Zbir je : ");
  saberi_brojeve(&a, &b, &rezultat);
  ispisi_broj (&rezultat);
  
  /* Mnoze se i ispisuje se proizvod */
  printf("Proizvod je : ");
  pomnozi_brojeve(&a, &b, &rezultat);
  ispisi_broj(&rezultat);

  /* Unosimo n i racunamo n! */
  printf("Uneti broj: ");
  scanf("%d", &n);
  faktorijel(n, &rezultat);
  printf("Faktorijel broja %d je: ", n);
  ispisi_broj(&rezultat);

  /* Unosimo n i ispisujemo prvih n Fibonacijevih brojeva */
  printf ("Uneti broj Fibonacijevih brojeva: ");
  scanf ("%d", &n);
  
  fibonachi (n, fib_niz);
  
  printf("Prvih %d Fibonacijevih brojeva su:\n", n);
  for (i = 0; i < n; i++)
    ispisi_broj (&fib_niz[i]);

  
  return 0;
}
