/* Program definise apstraktni tip Polinom, a zatim i nekoliko funkcija
   za rad sa polinomima. */

#include <stdio.h>
#include <stdlib.h>


/* Maksimalni stepen polinoma */
#define MAX_STEPEN 100

/* Definisemo apstraktni tip Polinom */
typedef struct polinom {
    double koeficienti[MAX_STEPEN + 1];
    int stepen;
} Polinom;


/* Funkcija ucitava stepen i koeficiente polinoma */
void ucitajPolinom(Polinom * p)
{
  int i;
  scanf("%d", &p->stepen);
  for(i = p->stepen; i >= 0; i--)
    scanf("%lf", &p->koeficienti[i]);
}


/* Funkcija ispisuje polinom u citljivom obliku. */
void ispisiPolinom(Polinom* p) 
{
  int i;
  
  for (i = p->stepen; i >= 0; i--) 
    {    
      /* ispisujemo samo clanove sa ne-nula koeficientom */
      if(p->koeficienti[i] != 0.0)
	{
	  if(i != p->stepen)
	    printf(" + ");
	  
	  printf("%.2f*x^%d", p->koeficienti[i], i);
	}
    }
  printf("\n");
}


/*  Funkcija izracunava vrednost polinoma p u tacki x
    Hornerovom shemom. */
double racunajVrednost(Polinom* p, double x) 
{
  int i;
  double suma = 0.0;
  for (i = p->stepen; i >= 0; i--) 
    {
      suma = suma * x + p->koeficienti[i];
    }
  return suma;
}

/* Funkcija sabira dva polinoma p i q i smesta zbir u r */ 
void saberiPolinome(Polinom* p, Polinom* q, Polinom * r) 
{
  int i;
  
  r->stepen = p->stepen > q->stepen ?  p->stepen : q->stepen;
  
  for (i = 0; i <= r->stepen; i++)
    r->koeficienti[i] =
      (i > p->stepen ? 0 : p->koeficienti[i]) + 
      (i > q->stepen ? 0 : q->koeficienti[i]);  
}


/*  Funkcija mnozi dva polinoma p i q i smesta proizvod u r  */
void pomnoziPolinome(Polinom* p, Polinom* q, Polinom * r) 
{
  int i, j;
  
  r->stepen = p->stepen + q->stepen;

  for(i = 0; i <= r->stepen; i++)
    r->koeficienti[i] = 0;

  for (i = 0; i <= p->stepen; i++) 
    {
      for (j = 0; j <= q->stepen; j++) 
	{
	  r->koeficienti[i+j] += p->koeficienti[i] * q->koeficienti[j];
	}
    }
}

/* Funkcija racuna izvod polinoma p i smesta ga u r */
void izvod(Polinom *p, Polinom * r)
{
  int i;
  r->stepen = p->stepen - 1;

  for(i = 0; i <= r->stepen; i++)
    r->koeficienti[i] = (i + 1) * p->koeficienti[i + 1];
}

/* Funkcija racuna n-ti izvod polinoma p i smesta ga u r */
void nIzvod(Polinom *p, Polinom *r, int n)
{
  int i;
  for(i = 0; i < n; i++)
    {
      izvod(p,r);
      *p = *r;
    }

  /* EFIKASNIJI NACIN:
     *r = *p;
     for(i = 0; i < n; i++)
       izvod(r, r);

     Pazljivo analizirati zbog cega ovo radi. U opstem slucaju nije dobra
     ideja koristiti isti memorijski prostor za ulazni i izlazni podatak,
     jer se ulazne informacije mozda jos uvek koriste u trenutku kada se
     u isti prostor upisuju izlazni rezultati. Prvi nacin je bezbedan,
     iako ne bas efikasan. Drugi nacin je efikasniji, ali nije uvek moguc!
  */
}


/* test program */
int main()
{

  double x;
  int n;
  Polinom p;
  Polinom q;
  Polinom r;

  ucitajPolinom(&p);
  ispisiPolinom(&p);
  ucitajPolinom(&q);
  ispisiPolinom(&q);

  saberiPolinome(&p,&q,&r);
  ispisiPolinom(&r);

  pomnoziPolinome(&p,&q,&r);
  ispisiPolinom(&r);

  scanf("%d", &n);
  nIzvod(&p, &r, n);
  ispisiPolinom(&r);

  scanf("%lf", &x);
  printf("%f\n", racunajVrednost(&p, x));

  return 0;
}
