.intel_syntax noprefix
		
.text
.global vowels

##########################################################################
##
## Funkcija:
##    int vowels(char *s);
##
##  izracunava broj parova uzastopnih samoglasnika u datom stringu.
##  Argumenti funkcije su:
##
## -- char * x -- [ebp+8] -- adresa datog stringa.
##
##########################################################################
vowels:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

	## Postavljamo smer kretanja kroz stringove.
	cld

	## Registar esi ce sadrzati adresu tekuceg karaktera u stringu.
	mov esi, [ebp + 8]

	## Registar ecx cemo koristiti kao brojac parova uzastopnih
	## samoglasnika.
	xor ecx, ecx

	## Registar edx ce imati vrednost 1 ako je prethodni karakter bio
	## samoglasnik, a u suprotnom 0.
	xor edx, edx
	
	## Registar al ce u svakoj iteraciji sadzati tekuci karakter, a
	## registar ah prethodni.
	xor eax, eax
		
next_char:
	## Ucitavamo sledeci karakter i proveravamo da li je u pitanju
	## terminirajuca nula.
	lodsb
	cmp al, 0
	je last_char

	## Proveravamo da li je tekuci karakter samoglasnik. 
	cmp al, 'a'
	je found
	cmp al, 'e'
	je found
	cmp al, 'i'
	je found
	cmp al, 'o'
	je found
	cmp al, 'u'
	je found	
	cmp al, 'A'
	je found
	cmp al, 'E'
	je found
	cmp al, 'I'
	je found
	cmp al, 'O'
	je found
	cmp al, 'U'
	je found
	
	jmp not_found

	
found:
	## Ako je tekuci karakter samoglasnik, tada se proverava da li
	## je i prethodni karakter bio samoglasnik, i ako jeste, uvecava
	## se brojac. 
	cmp edx, 0
	je skip
	inc ecx
	
skip:
	## Postavljamo edx na 1, jer je tekuci karakter samoglasnik (u
	## sledecoj iteraciji ce to biti prethodni karakter).
	mov edx, 1
	jmp continue
	
not_found:
	## Ako tekuci karakter nije samoglasnik, tada se u edx postavlja 0.
	mov edx, 0
	
continue:
	## Kopiramo tekuci karakter u ah -- to nam je sad prethodni karakter,
	## i prelazimo na sledecu iteraciju.
	mov ah, al
	jmp next_char
last_char:

	## Na kraju upisujemo vrednost brojaca u eax.
	mov eax, ecx
	
	
done:	
        ## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
        leave
        ret


