.text
.align 2


.global twobits

@ Funkcija:
@
@ 	int twobits(unsigned x);
@
@ izracunava broj pojavljivanja dve uzastopne jedinice u binarnom zapisu 
@ broja x. Argument funkcije je:
@
@ -- r0 -- unsigned x -- dati broj
@ 	
twobits:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Ideja algoritma: ako je binarni zapis datog broja dat kao
	@ x[31],x[30]...x[1],x[0], gde je x[i] bit na poziciji i u broju, 
	@ tada se pomeranjem u desno za jednu poziciju dobija vrednost 
	@ 0,x[31],x[30]...x[1]. Ako sada izvrsimo bitovsku konjukciju 
	@ dobijene i originalne vrednosti, dobijamo vrednost:
	@ 0,(x[30]&x[31]),(x[29]&x[30]),...,(x[0]&x[1]). Broj jedinica
	@ u ovom binarnom zapisu je upravo jednak broju uzastopnih
	@ parova jedinica u originalnom broju. 

	@ Kopiramo r0 u r3
	mov r3, r0
	
	@ Pomeramo r3 za jednu poziciju u desno (logicki)
	mov r3, r3, lsr #1

	@ Vrsimo logicku konjukciju r0 i r3.
	and r0, r0, r3

	@ Registar r1 ce biti brojac jedinica. Inicijalizujemo ga nulom.
	mov r1, #0 

	@ U registar r2 smestamo masku cija je vrednost inicijalno
	@ 1000...0000
	mov r2, #1
	mov r2, r2, lsl #31

	
next_bit:
	@ Dok maska ne postane nula
	cmp r2, #0
	beq last_bit

	@ Testiramo bit
	tst r0, r2

	@ Ako je jedan, uvecavamo brojac jedinica.
	addne r1, r1, #1
	
	@ Pomeramo masku za jednu poziciju u desno.
	mov r2, r2, lsr #1
	b next_bit
last_bit:

	@ Smestamo rezultat u r0
	mov r0, r1


	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
