#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

/* Deklaracija funkcije complex_roots(). */
void complex_roots(double x, double y, int n, double *rx, double *ry);

int main()
{
  double x, y;	/* Realni i imaginarni deo datog kompleksnog broja */
  int n;	/* Koren datog kompleksnog broja koga treba izracunati */
  double *rx, *ry; /* Pokazivaci na nizove realnih, odnosno imaginarnih
		      delova kompleksnih korena */
  int i;        /* Indeks u petlji */


  /* Ucitava se kompleksni broj i broj korena koje treba izracunati. */
  scanf("%lf%lf", &x, &y);
  scanf("%d", &n);
  assert(n > 0);
  
  /* Alocira se potreban prostor za nizove */
  assert((rx = malloc(sizeof(double) * n)) != NULL);
  assert((ry = malloc(sizeof(double) * n)) != NULL);
  
  /* Izracunavaju se koreni. */
  complex_roots(x, y, n, rx, ry);

  for(i = 0; i < n; i++)
    printf("%g %g\n", rx[i], ry[i]);
  
  free(rx);
  free(ry);

  return 0;
}
