.intel_syntax noprefix

.data
two:	.double 2.0
	
.text
.global complex_roots

########################################################################
##
## void complex_roots(double x, double y, int n, double *rx, double *ry);
##	
## Funkcija izracunava n-te korene kompleksnog broja z = x + iy
## (koreni se racunaju po formuli z_k = |z|^(1/n) * e^((arg(z) + 2kPi)n),
## za k = 0,1,...,n-1).
## Argumenti funkcije su:
##
## -- [ebp + 8] -- double x -- realni deo kompleksnog broja
## -- [ebp + 16] -- double y -- imaginarni deo kompleksnog broja
## -- [ebp + 24] -- int n    -- broj korena koji se racuna
## -- [ebp + 28] -- double *rx -- pokazivac na niz u koji treba upisati
##                                realne delove korena
## -- [ebp + 32] -- double *ry -- pokazivac na niz u koji treba upisati
##                                imaginarne delove korena
##
#######################################################################
	
complex_roots:
        ## Prolog funkcije.
        enter	0, 0
	push	esi
	push    edi

	## Kompleksni broj re+im*i ce biti prvo preveden u polarne
	## koordinate r*e^(i*fi), a potom ce njegov n-ti koreni biti
	## izracunati po gore opisanoj formuli.
	
	## Racuna se reciprocna vrednost broja korena.
	fld1				# Stek: 1
	fidiv	dword ptr [ebp + 24]	# Stek: 1/n

	## Racuna se polarna koordinata r=sqrt(x*x+y*y).
	fld	qword ptr [ebp+8]	# Stek:	1/n, x
	fmul	st			# Stek:	1/n, x*x
	fld	qword ptr [ebp+16]	# Stek:	1/n, x*x, y
	fmul	st			# Stek:	1/n, x*x, y*y
	faddp				# Stek:	1/n, x*x+y*y
	fsqrt				# Stek:	1/n, sqrt(x*x+y*y)=r

	## Racuna se n-ti koren koordinate r. U komentarima je sa
	## int() oznacen celobrojni, a sa frac() razlomljeni deo
	## realnog broja.
	fyl2x			# Stek:	1/n*log2(r)=log2(r^(1/n))=L
	fld	st		# Stek:	L, L
	frndint			# Stek:	L, int(L)
	fsub	st(1), st	# Stek:	L-int(L)=frac(L), int(L)
	fxch			# Stek:	int(L), frac(L)
	f2xm1			# Stek:	int(L), 2^frac(L)-1
	fld1			# Stek:	int(L), 2^frac(L)-1, 1
	faddp			# Stek:	int(L), 2^frac(L)
	fscale			# Stek:	int(L), 2^int(L)*2^frac(L)=2^(int(L)+frac(L))=2^L
	fxch			# Stek:	2^L, int(L)
	ffree	st		# Stek:	2^L, invalidna vrijednost
	fincstp			# Stek:	2^L=2^log2(r^(1/n))=r^(1/n)

	## Racuna se polarna koordinata fi.
	fld	qword ptr [ebp+16]	# Stek:	r^(1/n), y
	fld	qword ptr [ebp+8]	# Stek:	r^(1/n), y, x
	fpatan				# Stek:	r^(1/n), atan(y/x)=fi

	## U svakoj iteraciji petlje racunamo z_k = r^(1/n) * e^((fi + 2kPi)/n)

	## U ecx smestamo n (broj iteracija). U esi smestamo adresu niza rx
	## a u edi adresu niza ry.
	mov ecx, [ebp + 24]
	mov esi, [ebp + 28]
	mov edi, [ebp + 32]

					# Stek: r^(1/n), fi + 2kPi (k = 0)
next_root:
	fld   st                        # Stek: r^(1/n), fi + 2kPi, fi + 2kPi	
	
	## Racuna se vrednost (fi +  2kPi)/n.
	fidiv	dword ptr [ebp+24]	# Stek:	r^(1/n), fi + 2kPi,(fi+ 2kPi)/n
	                                # Stek:	r^(1/n), fi + 2kPi, fi_k
	
	## Racuna se realna koordinata tekuceg korena datog kompleksnog broja
	## r^(1/n)*cos((fi + 2kPi)/n) i smesta na odgovarajucu lokaciju u
	## memoriji.
	fld st                  # Stek: r^(1/n), fi+2kPi, fi_k, fi_k

	fcos			# Stek:	r^(1/n), fi+2kPi, fi_k, cos(fi_k)

	fmul st(3)		# Stek:	r^(1/n),fi+2kPi,fi_k,r^(1/n)*cos(fi_k)
	
	fstp	qword ptr [esi]	# Stek:	r^(1/n), fi+2kPi,fi_k
	add esi, 8
	
	## Racuna se imaginarna koordinata tekuceg korena datog kompleksnog
	## broja r^(1/n)*sin((fi + 2kPi)/n) i smesta na odgovarajucu lokaciju u
	## memoriji.
	fld st                  # Stek: r^(1/n), fi+2kPi, fi_k, fi_k

	fsin			# Stek:	r^(1/n), fi+2kPi, fi_k, sin(fi_k)

	fmul st(3)		# Stek:	r^(1/n),fi+2kPi,fi_k,r^(1/n)*sin(fi_k)
	
	fstp	qword ptr [edi]	# Stek:	r^(1/n), fi+2kPi,fi_k
	add edi, 8

	
	fcomp                   # Stek: r^(1/n), fi+2kPi

	## Dodajemo s*Pi na fi
	fldpi                   # Stek: r^(1/n), fi+2kPi, Pi
	fld qword ptr two       # Stek: r^(1/n), fi+2kPi, Pi,2
	fmulp                   # Stek: r^(1/n), fi+2kPi, 2*Pi
	faddp                   # Stek: r^(1/n), fi+2kPi+2Pi
				# Stek: r^(1/n), fi+2(k+1)Pi

	## Prelazimo na sledeci koren
	loop next_root
	
        ## Epilog funkcije.
	pop	edi
	pop 	esi
        leave
        ret
