.text
.align 2

@ Konstante koje se koriste kao maske. Podsetimo se da instrukcije za 
@ obradu podataka (add, orr, and, itd.) kao i instrukcija mov ne mogu
@ imati proizvoljnu konstantu za operand, tako da je bezbedno resenje
@ konstantu definisati u sekciji sa podacima, a onda je ucitavati iz
@ memorije instrukcijom ldr, navodeci labelu koja je navedena ispred
@ konstante (kao sto je to uradjeno u nastavku).

C1: .int 0xFFFFFF80
C2: .int 0xFFFFF800
C3: .int 0xFFFF0000

C4: .int 0x0000001F
C5: .int 0x000000C0
C6: .int 0x0000003F
C7: .int 0x00000080

C8: .int 0x0000000F
C9: .int 0x000000E0

C10: .int 0x00000007
C11: .int 0x000000F0

.global unicode2utf8

@ Funkcija:
@
@ 	int unicode2utf8(unsigned unicode, unsigned char * utf8);
@
@ odredjuje UTF-8 kodiranje datog unicode karaktera. Argumenti funkcije 
@ su: 
@
@ -- r0 -- unsigned unicode -- vrednost unicode karaktera.
@ -- r1 -- unsigned char * utf8 -- adresa niza bajtova u koje se upisuje 
@ rezultat.
@ 
@ Funkcija vraca broj UTF-8 bajtova (1, 2, 3 ili 4).	
@
unicode2utf8:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Ucitavamo konstantu 0xFFFFFF80 i vrsimo bitovsku konjukciju
	@ sa datim unicode karakterom. Ako je rezultat nula, tada je
	@ u pitanju jednobajtni slucaj.
	ldr r2, C1
	tst r0, r2
	beq one

	@ Ucitavamo konstantu 0xFFFFF800 i vrsimo bitovsku konjukciju
	@ sa datim unicode karakterom. Ako je rezultat nula, tada je
	@ u pitanju dvobajtni slucaj.
	ldr r2, C2
	tst r0, r2
	beq two

	@ Ucitavamo konstantu 0xFFFF0000 i vrsimo bitovsku konjukciju
	@ sa datim unicode karakterom. Ako je rezultat nula, tada je
	@ u pitanju trobajtni slucaj.
	ldr r2, C3
	tst r0, r2
	beq three

	@ Inace je cetvorobajtni slucaj.
	b four


one:
	@ U jednobajtnom slucaju, upisujemo najnizi bajt unicode 
	@ karaktera u prvi element izlaznog niza. Vracamo 1.
	strb r0, [r1]
	mov r0, #1
	b done

two:
	@ U dvobajtnom slucaju, upisujemo najpre bajt 110yyyyy, gde su
	@ yyyyy visih 5 bitova (od 11 znacajnih bitova) unicode 
	@ karaktera. 
	ldr r2, C4
	and r2, r2, r0, lsr #6
	ldr r3, C5
	orr r2, r2, r3
	strb r2, [r1], #1
		
	@ Zatim upisujemo bajt 10xxxxxx, gde su xxxxxx nizih 6 bitova 
	@ unicode karaktera.
	ldr r2, C6
	and r2, r2, r0
	ldr r3, C7
	orr r2, r2, r3
	strb r2, [r1] 	

	@ Vracamo 2.
	mov r0, #2
	b done

three:
	@ U trobajtnom slucaju, najpre upisujemo bajt 1110zzzz, gde su
	@ zzzz 4 najvisa (od 16 znacajnih) bita unicode karaktera.
	ldr r2, C8	
	and r2, r2, r0, lsr #12
	ldr r3, C9
	orr r2, r2, r3
	strb r2, [r1], #1

	@ Zatim upisujemo bajt 10yyyyyy, gde su yyyyyy sledecih 6 
	@ znacajnih bitova (sa leva u desno) unicode karaktera.	
	ldr r2, C6
	and r2, r2, r0, lsr #6
	ldr r3, C7
	orr r2, r2, r3
	strb r2, [r1], #1

	@ Na kraju upisujemo bajt 10xxxxxx, gde su xxxxxx najnizih 6
	@ bitova unicode karaktera.
	ldr r2, C6
	and r2, r2, r0
	ldr r3, C7
	orr r2, r2, r3
	strb r2, [r1]

	@ Vracamo 3.
	mov r0, #3
	b done

four:
	@ U slucaju cetiri bajta, najpre upisujemo bajt 11110www, gde su
	@ www tri najvisa (od 21 znacajnih) bita unicode karaktera.
	ldr r2, C10
	and r2, r2, r0, lsr #18
	ldr r3, C11
	orr r2, r2, r3
	strb r2, [r1], #1

	@ Zatim upisujemo bajt 10zzzzzz, gde su zzzzzz sledecih 6 bitova
	@ unicode karaktera (sa leva u desno).
	ldr r2, C6
	and r2, r2, r0, lsr #12
	ldr r3, C7
	orr r2, r2, r3
	strb r2, [r1], #1

	@ Zatim upisujemo bajt 10yyyyyy, gde su yyyyyy sledecih 6 bitova
	@ unicode karaktera (sa leva u desno).
	ldr r2, C6
	and r2, r2, r0, lsr #6
	ldr r3, C7
	orr r2, r2, r3
	strb r2, [r1], #1

	@ Na kraju upisujemo bajt 10xxxxxx, gde su xxxxxx najnizih 6 
	@ bitova unicode karaktera.
	ldr r2, C6
	and r2, r2, r0
	ldr r3, C7
	orr r2, r2, r3
	strb r2, [r1]
	
	@ Vracamo 4.
	mov r0, #4
	b done


done:

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
