.intel_syntax noprefix

.text
.global fractions

##########################################################################
##
## Funkcija:
##
## void fractions(int f1[], int f2[], int r[]);
##
## odredjuje zbir dva razlomka. Razlomci se zadaju kao nizovi celih brojeva
## duzine 2, pri cemu je prvi element tog niza brojilac, a drugi imenilac.
##
## Argumenti funkcije su:
##
## -- int * f1 -- [ebp+8]  -- adresa pocetka niza koji sadrzi brojilac i
## imenilac prvog razlomka.
## -- int * f2 -- [ebp+12]  -- adresa pocetka niza koji sadrzi brojilac i
## imenilac drugog razlomka.
## -- int * r -- [ebp+16]  -- adresa pocetka niza u koji treba upisati
## brojilac i imenilac rezultata.
##
###########################################################################
fractions:
        ## Prolog funkcije.
        enter   0, 0
	push esi
	push edi
	push ebx

	
	## U registar esi ucitavamo adresu prvog niza, a u edi drugog niza.
	mov esi, [ebp+8]
	mov edi, [ebp+12]

	## U registar eax ucitavamo imenilac prvog razlomka q1, a u registar
	## ebx ucitavamo imenilac drugog razlomka q2. Mnozimo q1 * q2, to ce
	## biti imenilac zbira. Smestamo proizvod u ebx.
	mov eax, [esi + 4]
	mov ebx, [edi + 4]
	imul ebx
	mov ebx, eax

	## U registar eax ucitavamo brojilac prvog razlomka p1, a u registar
	## ecx ucitavamo imenilac drugog razlomka q2. Mnozimo p1 * q2 i
	## smestamo dobijeni proizvod u ecx.
	mov eax, [esi]
	mov ecx, [edi + 4]
	imul ecx
	mov ecx, eax

	## U registar eax ucitavamo imenilac prvog razlomka q1, a u registar
	## edx smestamo brojilac drugog razlomka p2. Mnozimo q1 * p2. Dobijeni
	## proizvod smestamo u edx.
	mov eax, [esi + 4]
	mov edx, [edi]
	imul edx
	mov edx, eax
	

	## Sabiramo q1 * p2 + p1 * q2. Sada se brojilac zbira p nalazi u ecx,
	## a imenilac q u ebx.
	add ecx, edx

	## Cuvamo kopije brojioca i imenioca u registrima esi i edi.
	mov esi, ecx
	mov edi, ebx
	
	## Radi skracivanja razlomka, nalazimo NZD(p,q) Euklidovim algoritmom.
	## Dokle god je q != 0, delimo p sa q, zatim
	## p postaje q, a q postaje ostatak p % q. Kada se petlja zavrsi,
	## tada je vrednost p (registar ecx) upravo NZD(p, q)
next:
	cmp ebx, 0
	je last

	mov eax, ecx
	cdq
	idiv ebx
	mov ecx, ebx
	mov ebx, edx
	jmp next
last:

	## Delimo brojilac p sa NZD(p,q), dobijeni kolicnik smestamo u esi.
	mov eax, esi
	cdq
	idiv ecx
	mov esi, eax

	## Delimo imenilac q sa NZD(p,q), dobijeni kolicnik smestamo u edi.
	mov eax, edi
	cdq
	idiv ecx
	mov edi, eax

	## Smestamo dobijene vrednosti nakon skracivanja na za to predvidjene
	## lokacije.
	mov ebx, [ebp + 16]
	mov [ebx], esi
	mov [ebx + 4], edi

        ## Epilog funkcije.
	pop ebx
	pop edi
	pop esi
        leave
        ret
