#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#define X 0  /* X koordinata centra kruga */
#define Y 1  /* Y koordinata centra kruga */
#define R 2  /* Poluprecnik kruga */ 

/* Deklaracija asemblerske funkcije */
int circles(int n, double * cr); 

/* Test program */
int main()
{
  double * cr;   /* Pokazivac na niz sa podacima o krugovima */
  int n;         /* Broj krugova */ 
  int r;         /* Rezultat */
  int i;         /* Brojac */

  /* Ucitavamo ulazne podatke */
  assert(scanf("%d", &n) == 1);
  assert(n > 1);
  
  /* Alociramo prostor */
  cr = malloc(sizeof(double) * 3 * n);
  assert(cr != NULL);
  
  /* Za svaki od n krugova ucitavamo X i Y koordinatu centra i poluprecnik R */
  for(i = 0; i < n; i++)
    {
      assert(scanf("%lf%lf%lf", 
		   &cr[3 * i + X], 
		   &cr[3 * i + Y], 
		   &cr[3 * i + R]) == 3);
    }
  
  /* Pozivamo asemblersku funkciju */
  r = circles(n, cr);
  
  /* Prikazujemo rezultat */
  printf("%d\n", r);

  /* Oslobadjamo memoriju */
  free(cr);

  return EXIT_SUCCESS;
}
