.intel_syntax noprefix


.text
.global smallest

##############################################################################
##
## unsigned smallest(unsigned x);
##
## -- unsigned x -- [ebp+8] -- ceo broj koji se unosi sa ulaza 
##
##############################################################################
smallest:
	## Prolog funkcije
	enter 0,0

	## Inicijalizujemo eax. U ovaj registar cemo utiskivati po jedan bit
	## sa desne strane svaki put kada u ulaznom podatku naidjemo na bit 1.
	## U registar ecx ucitavamo podatak sa ulaza. 
	xor eax,eax
	mov ecx, [ebp+8]
	
next_bit:
	## Ako nema vise bitova koji su postavljeni na 1 u ulaznom podatku,
	## tada napustamo petlju. 
	jecxz done

	## Potiskujemo krajnji desni bit ulaznog podatka u carry flag.
	shr ecx
	
	## Ako je potisnuti bit 1, tada tu jedinicu utiskujemo u registar eax,
	## sa desne strane.
	jc insert_one
	
	## Prelazimo na sledeci bit.
	jmp next_bit
	
	jmp done
	
insert_one:
	## Rotacijom kroz carry flag u levo postizemo da se sacuvana jedinica
	## od malo pre ubaci sa desne strane u registar eax.
	rcl eax

	## Prelazimo na sledeci bit
	jmp next_bit

done:
	## Epilog funkcije
	leave
	ret
	