.intel_syntax noprefix


.text
.global eratosthenes
	
###############################################################################
# void eratosthenes(int n, int *primes); 
#
# int n -- [ebp+8] -- broj n prostih brojeva koji se traze
# int * primes -- [ebp+12] -- adresa niza u koji smestamo proste brojeve.
###############################################################################

eratosthenes:
	## Prolog funkcije.
	enter 0,0
	push edi
	push esi
	push ebx
	
	## Ideja algoritma: inicijalno u niz smestamo  broj 2, kao
	## prvi prost broj. Nakon toga u glavnoj petlji  prolazimo
	## kroz sve brojeve pocev od 3, i za svaki od  njih  prove-
	## ravamo da li je deljiv bar nekim od brojeva koji su vec
	## u nizu. Ako jeste, preskacemo ga. Ako nije, dodajemo ga
	## u niz.

	
	## Postavljamo ecx na nulu. Ovaj registar ce nam biti brojac
	## do sada pronadjenih prostih brojeva.
	xor ecx,ecx
	
	## Smestamo  broj  dva  kao  prvi  element  u  nizu 
	## (prvi prost broj), nakon  cega  uvecavamo  brojac  ecx. 
	mov eax,2
	mov edi, [ebp+12]
	mov [edi], eax
	inc ecx

	## Registar edi ce nam od sada cuvati broj za koji trenutno
	## ispitujemo da li je prost ili ne. On ce se u svakoj ite-
	## raciji uvecavati za jedan. Postavljamo ga na 2, zbog toga
	## sto se uvecanje vrednosti vrsi na pocetku iteracije.
	mov edi, 2
	
	## Postavljamo smer kretanja kroz niz s leva u desno.
	cld	
	
		
	## U ovoj  petlji  prolazimo  kroz cele brojeve pocev od tri,
	## i za svaki od  njih  proveravamo da li je deljiv nekim od
	## prethodno pronadjenih  prostih brojeva. Trenutna vrednost
	## broja koji ispitujemo  se  nalazi  u registru edi, a broj
	## do sada pronadjenih  prostih  brojeva u registru ecx.
main_loop:

	## Uslov izlaska iz petlje: ako je ecx == n, tj. ako smo
	## vec pronasli n prostih brojeva.
	cmp ecx, [ebp+8]
	jge done

	## Prelazimo na ispitivanje sledeceg broja.
	inc edi

	## Registar ecx cemo koristiti kao brojac u unutrasnjoj petlji
	## pa zato  moramo da ga sacuvamo na steku, kako bismo kasnije
	## mogli da povratimo vrednost brojaca spoljasnje petlje.
	push ecx

	## U registar esi smestamo adresu niza. Ovo nam je potrebno za
	## unutrasnju  petlju, u kojoj  cemo ucitavati do sada upisane
	## proste brojeve iz niza, i proveravati  da li je tekuci broj
	## deljiv nekim od njih.
	mov esi, [ebp+12]

	## Petlja u kojoj proveravamo  deljivost  tekuceg broja nekim od
	## do sada pronadjenih prostih brojeva. Petlja ima ecx iteracija,
	## tj. upravo  onoliko  koliko  ima  do sada pronadjenih prostih 
	## brojeva  u nizu.
next_prime:

	## Ucitavamo sledeci  prost broj iz niza, premestamo ga u ebx,
	## a u eax smestamo tekuci broj koji ispitujemo. Delimo zatim
	## eax sa ebx.
	lodsd
	mov ebx,eax
	mov eax,edi
	cdq
	idiv ebx

	## Ako je ostatak 0, tada je broj deljiv nekim brojem, pa nije prost.
	cmp edx, 0
	je not_prime

	## Ako nije deljiv, tada prelazimo na sledeci prost broj iz niza
	loop next_prime

	jmp prime	
	
not_prime:
	## Ako broj nije prost, tada prosto prelazimo na sledeci broj, tj.
	## na  sledecu iteraciju  spoljasnje  petlje. Prethodno moramo da
	## povratimo vrednosti brojaca glavne petlje.
	pop ecx
	jmp  main_loop

	jmp done
prime:
	## Ako je broj prost, treba ga sacuvati kao sledeci element u nizu.
	## S obzirom da registar esi sada pokazuje na poziciju u nizu iza
	## poslednjeg upisanog broja, to je upravo pozicija na koju treba
	## smestiti novi broj. 
	mov [esi],edi

	## Vracamo vrednost brojaca spoljne petlje, i uvecavamo je za jedan,
	## jer smo upravo u niz smestili jos jedan prost broj.
	pop ecx
	inc ecx
	jmp main_loop

done:
	## Epilog funkcije	
	pop ebx
	pop esi
	pop edi
	leave
	ret
	
