#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#define MAX_TEXT 1024

/* Deklaracija asemblerske funkcije */
void crypt (char *text, int n);

/* Test program */
int
main (int argc, char **argv)
{

  char text[MAX_TEXT];
  int n;
  
  /* Ucitavamo string sa ulaza, uz proveru pojave greske */
  errno = 0;
  clearerr (stdin);
  if (fgets (text, MAX_TEXT, stdin) == NULL)
    if (ferror (stdin))
      {
	fprintf (stderr, "%s: fgets() error: %s\n", argv[0],
		 strerror (errno));
	exit (EXIT_FAILURE);
      }
  
   /* Unosimo n */
  assert(scanf("%d", &n) == 1 && n > 0 && n < 26);

  /* Kriptovanje teksta */
  crypt (text, n);

  /* Ispisujemo kodirani string na izlaz, uz proveru pojave greske */
  errno = 0;
  clearerr (stdout);
  if (fputs (text, stdout) == EOF)
    if (ferror (stdout))
      {
	fprintf (stderr, "%s: fputs() error: %s\n", argv[0],
		 strerror (errno));
	exit (EXIT_FAILURE);
      }

  return EXIT_SUCCESS;
}
