.intel_syntax noprefix

		
.text
.global crypt

############################################################################# 
##
## void crypt(char * text, int n); 
##
## char * text -- [ebp+8] -- tekst koji se kodira
## int n       -- [ebp+12] -- pomeraj
#############################################################################
crypt:
	## Prolog funkcije
	enter 0,0
	push edi
	push esi

	## U registre esi i edi ucitavamo adresu stringa u kome se nalazi
	## tekst koji se kodira.
	mov esi, [ebp+8]
	mov edi, [ebp+8]

	## U registar edx smestamo broj n, tj. za koliko se pozicija u abecedi
	## pomera svako slovo. 
	mov edx, [ebp+12]
	
	## Postavljamo smer kretanja kroz string sa leva u desno. 
	cld
	
	## Inicijalizujemo registar eax.
	xor eax,eax
	
next_char:
	## Ucitavamo sledeci karakter teksta. Ukoliko je 0, tada smo dosli do
	## kraja stringa, pa prekidamo petlju.
	lodsb
	cmp al,0
	je done

	## Najpre proveravamo da li je ucitani karakter malo slovo. Ako nije,
	## tada skacemo na proveru velikog slova, a ako jeste, onda kodiramo
	## malo slovo. 
check_a:	
	cmp al, 'a'
	jl check_A
check_z:
	cmp al, 'z'
	jg check_A

	## Kodiramo malo slovo. Kopiramo u ah 'a', i prelazimo na kod koji je
	## zajednicki za velika i mala slova.
a_to_z:
	mov ah,'a'
	jmp letter

	## Proveravamo da li je ucitani karakter veliko slovo.Ako nije, pre- 
	## skacemo taj karakter, a ako jeste, tada kodiramo veliko slovo.
check_A:
	cmp al, 'A'
	jl skip
check_Z:
	cmp al, 'Z'
	jg skip

	## Kodiramo veliko slovo. Kopiramo u ah 'A', i prelazimo na kod koji 
	## je zajednicki za velika i mala slova.
A_to_Z:
	mov ah,'A'
	jmp letter

	## Ukoliko je karakter slovo, tada oduzimamo 'a' odnosno 'A',
	## dodajemo n, zatim proveravamo da li je dobijeni broj veci od
	## 25. Ako jeste, oduzimamo 26. Nakon toga se ponovo dodaje 'a' 
	## (odnosno 'A').	 
letter:	
	sub al,ah
	add al,dl
	cmp al,25
	jle add_ah
	sub al,26
add_ah:	
	add al,ah
	
	## Kodirano slovo upisujemo u string.
	stosb
	jmp next_char

skip:
	## U slucaju da karakter nije slovo, tada ga ne kodiramo, vec se samo
	## pomeramo za jednu poziciju u desno u odredisnom stringu.
	inc edi
	jmp next_char
	
done:
	## Epilog funkcije.
	pop esi
	pop edi
	leave
	ret
	