.intel_syntax noprefix

.text
.global root

	## Funkcija root() racuna n-ti korijen datog kompleksnog broja.
	## Argumenti funkcije su:
	##   [ebp+8], [ebp+16] - realni i imaginarni dio datog broja
	##   [ebp+24] - broj korijena koga treba izracunati
	##   [ebp+28], [ebp+32] - adrese na koje treba smjestiti realni
	##                        i imaginarni dio n-tog korijena
	## Pretpostavlja se da je broj korijena pozitivan. Funkcija se u 
	## potpunosti podrvrgava C konvencijama pozivanja.
root:
        ## Prolog funkcije.
        enter	0, 0
	push	ebx

	## Kompleksni broj re+im*i ce biti prvo preveden u polarne
	## koordinate r*e^(i*fi), a potom ce njegov n-ti korijen biti
	## izracunat kao r^(1/n)*(cos(fi/n)+i*sin(fi/n)).
	
	## Racuna se reciprocna vrijednost broja korijena.
	fld1				# Stek: 1
	fidiv	dword ptr [ebp+24]	# Stek: 1/n

	## Racuna se polarna koordinata r=sqrt(re*re+im*im).
	fld	qword ptr [ebp+16]	# Stek:	1/n, im
	fmul	st			# Stek:	1/n, im*im
	fld	qword ptr [ebp+8]	# Stek:	1/n, im*im, re
	fmul	st			# Stek:	1/n, im*im, re*re
	faddp				# Stek:	1/n, re*re+im*im
	fsqrt				# Stek:	1/n, sqrt(re*re+im*im)=r

	## Racuna se n-ti korijen koordinate r. U komentarima je sa
	## int() oznacen cjelobrojni, a sa frac() razlomljeni dio
	## realnog broja.
	fyl2x			# Stek:	1/n*log2(r)=log2(r^(1/n))=L
	fld	st		# Stek:	L, L
	frndint			# Stek:	L, int(L)
	fsub	st(1), st	# Stek:	L-int(L)=frac(L), int(L)
	fxch			# Stek:	int(L), frac(L)
	f2xm1			# Stek:	int(L), 2^frac(L)-1
	fld1			# Stek:	int(L), 2^frac(L)-1, 1
	faddp			# Stek:	int(L), 2^frac(L)
	fscale			# Stek:	int(L), 2^int(L)*2^frac(L)=2^(int(L)+frac(L))=2^L
	fxch			# Stek:	2^L, int(L)
	fcomp			# Stek:	2^L=2^log2(r^(1/n))=r^(1/n)

	## Racuna se polarna koordinata fi.
	fld	qword ptr [ebp+16]	# Stek:	r^(1/n), im
	fld	qword ptr [ebp+8]	# Stek:	r^(1/n), im, re
	fpatan				# Stek:	r^(1/n), atan(im/re)=fi

	## Racuna se vrijednost fi/n, kao i sinus i kosinus toga ugla.
	fidiv	dword ptr [ebp+24]	# Stek:	r^(1/n), fi/n
        fsincos                         # Stek:	r^(1/n), sin(fi/n), cos(fi/n)

	## Racuna se realna koordinata korijena datog kompleksnog broja
	## r^(1/n)*cos(fi/n) i smjesta na odgovarajucu lokaciju u memoriji.
	fmul    st, st(2)		# Stek:	r^(1/n), sin(fi/n), r^(1/n)*cos(fi/n)
	mov	ebx, [ebp+28]
	fstp	qword ptr [ebx]         # Stek:	r^(1/n), sin(fi/n)

	## Racuna se imaginarna koordinata korijena datog kompleksnog broja
	## r^(1/n)*sin(fi/n) i smjesta na odgovarajucu lokaciju u memoriji.
	fmulp                           # Stek:	r^(1/n)*sin(fi/n)
	mov	ebx, [ebp+32]
	fstp	qword ptr [ebx]
	
        ## Epilog funkcije.
	pop	ebx
        leave
        ret
