.intel_syntax noprefix

.data
three:	.int 3
	
.text

.global ln_sequence

###########################################################################
##
## Funkcija:
##
## int ln_sequence(double eps);
## 
## vraca najmanje n takvo da je izraz ln(1+1/n) manji od eps.
## 
## -- double eps -- [ebp+8]
##
########################################################################## 
ln_sequence:

	## Prolog funkcije
	enter 0,0

	## Ucitavamo eps na stek. Zatim na stek postavljamo broj 3. U tom
	## registru cemo cuvati n. U komentarima cemo sa np oznacavati
	## prethodno n, a sa n tekuce n. Vrednost n se uvecava na pocetku
	## svake iteracije, tako da ce prva vrednost n koja se koristi biti
	## 4. Manje vrednosti (1, 2 i 3) ne bi ni mogle da se koriste, zato
	## sto bi u tom slucaju x=1/n u instrukciji fyl2xp1 bilo izvan
	## dozvoljenog opsega ( [-h,+h] gde je h = 1 - sqrt(2)/2). 
	## Pretpostavicemo, zbog jednostavnosti, da je trazeno n uvek vece od
	## 3, tj. da je preciznost eps dovoljno mala.
	fld qword ptr [ebp+8]			## stek: eps
	fild dword ptr three			## stek: eps,3=np
	
main_loop:

						## stek: eps,np

	## Racunamo ln(1+1/n)
	fld1					## stek: eps,np,1
	faddp					## stek: eps,np+1=n
	fld1					## stek: eps,n,1
	fdiv st(0),st(1)			## stek: eps,n,1/n
	fld1					## stek: eps,n,1/n,1
	fxch					## stek: eps,n,1,1/n
	fyl2xp1					## stek: eps,n,1*log_2(1/n+1)
	fldl2e					## stek: eps,n,log_2(1/n+1),
						##       log_2(e)
	fdivp					## stek: eps,n,
						##       log_2(1/n+1)/log_2(e)

						## stek: eps,n,ln(1/n+1)

	## Uporedjujemo dobijenu vrednost sa eps.	
	fcomip	st, st(2)			## stek: eps,n

						
	## Ako je manja, prekidamo petlju. 
	jb done
	
						## stek: eps,np
	jmp main_loop
	
done:
	## Prebacujemo poslednju vrednost n u registar eax (povratna vrednost)
	## a zatim skidamo preostale vrednosti sa fpu steka.

						## stek: eps,n
	sub esp,4
	fistp dword ptr [esp]			## stek: eps
	pop eax
	fcomp					## stek:

	## Epilog funkcije
	leave
	ret
	