.intel_syntax noprefix

.text

.global dirichlet

##############################################################################
##
## Funkcija:	
##
## double dirichlet(double x, int n);
##
## racuna vrednost Dirichlet-ovog jezgra reda n u tacki x:
##
## Dn(x) = 1 + 2 * sum_{1<=i<=n} cos(i*x)
##
## -- double x -- ebp + 8 -- tacka u kojoj racunamo vrednost 
## -- int n -- ebp + 16 -- red Dirichlet-ovog jezgra
##
##############################################################################
dirichlet:

	## Prolog funkcije
	enter 0,0

	## Ucitavamo u ecx vrednost n
	mov ecx, [ebp+16]

	## Ucitavamo 1 na vrh steka. 
	fld1				## stek: 1
	
	## Ako je n == 0, prekidamo funkciju. Vrednost koju funkcija vraca
	## je 1. Ona se upravo i nalazi u registru st(0).
	jecxz done

	## Ucitavamo nulu (pocetna vrednost sume) i vrednost x na stek.
	fldz				## stek: 1,0=S
	fld qword ptr [ebp+8]		## stek: 1,S,x

	## U ovoj petlji racunamo sumu. Indeks petlje i uzima vrednosti
	## pocev od n do 1.
main_loop:

					## stek: 1,S,x
	
	## Racunamo cos(i*x) i dodajemo ga na sumu. Ucitavanje celog broja 
	## moguce je samo iz memorije, pa zato moramo najpre vrednost 
	## registra ecx (i) da postavimo na stek.
	fld st				## stek: 1,S,x,x
	push ecx
	fild dword ptr [esp]		## stek: 1,S,x,x,i
	add esp,4
	fmulp				## stek: 1,S,x,i*x
	fcos				## stek: 1,S,x,cos(i*x)
	faddp st(2),st(0)	        ## stek: 1,S,x
	
	loop main_loop

	## Racunamo D=1+2*S
	fcomp				## stek: 1,S
	fld st				## stek: 1,S,S
	faddp				## stek: 1,2*S
	faddp				## stek: 1+2*S=D

done:	
	## Epilog funkcije
	leave
	ret

	