#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <assert.h>

/* Deklaracija asemblerske funkcije */
double ctg_sum(double x[], int n);

/* Test program */
int main(int argc, char **argv)
{

  double *x;
  int n, i;

  /* Ucitavamo n >= 0 */
  assert(scanf("%d", &n) == 1 && n >= 0);

  /* Alociramo prostor za elemente niza */
  if((x = malloc(sizeof(double) * n)) == NULL)
    {
      fprintf(stderr, "%s: malloc() error: %s\n", argv[0], strerror(errno));
      exit(EXIT_FAILURE);
    }

  /* Ucitavamo elemente */
  for(i = 0; i < n; i++)
    assert(scanf("%lf", x + i) == 1);

  /* Pozivamo funkciju i ispisujemo rezultat */
  printf("%g\n", ctg_sum(x, n));

  /* Oslobadjamo prostor */
  free(x);

  return EXIT_SUCCESS;
}

