.intel_syntax noprefix

.text

.global ctg_sum

############################################################################
##
## Funkcija:
##
## double ctg_sum(double x[], int n);
##
## racuna vrednost izraza:
##
## E = sum_{0<=i<n-1} (ctg(x_{i+1}) - ctg(x_{i})) / (x_{i+1} - x_{i})
##
## -- double x[] -- ebp + 8 
## -- int n -- ebp + 12
##
########################################################################### 
ctg_sum:

	## Prolog funkcije
	enter 0,0
	push esi

	## Ucitavamo adresu niza u registar esi
	mov esi, [ebp+8]

	## Postavljamo na stek nulu kao inicijalnu vrednost sume.
	fldz				## stek: 0=E

	## Ucitavamo broj elemenata niza. Ako je nula, preskacemo petlju. 
	mov ecx, [ebp+12]
	jecxz done

	## Umanjujemo ecx za jedan, zato sto je broj elemenata u sumi, 
	## pa samim tim i broj iteracija u petlji, jednak n-1.
	dec ecx

	## Ako je nakon ovog umanjenja ecx 0, to znaci da je u nizu bio samo
	## jedan element, sto znaci da je suma opet nula, pa preskacemo petlju.
	jecxz done

	## Inicijalno ucitavamo na stek prvi element i njegov kotangens.
	## Registar esi uvecavamo za 8, cime ga postavljamo na adresu
	## sledeceg elementa u nizu.
	fld qword ptr [esi]		## stek: E,x
	add esi,8
	fld st				## stek: E,x,x
	fptan				## stek: E,x,tan(x),1
	fdivrp				## stek: E,x,ctg(x)

	
					## stek: E,x,ctg(x)	
main_loop:

	## Ucitavamo sledeci element, a zatim pomeramo pokazivac esi na
	## naredni element (za sledecu iteraciju). U komentaru cemo
	## ranije ucitani element niza preoznaciti u xp, kako bi se
	## razlikovao od tekuceg. 
	fld qword ptr [esi]		## stek: E,xp,ctg(xp),x
	add esi,8

	## Racunamo kotangens tekuceg elementa x
	fld st				## stek: E,xp,ctg(xp),x,x
	fptan				## stek: E,xp,ctg(xp),x,tan(x),1
	fdivrp				## stek: E,xp,ctg(xp),x,ctg(x)

	## Racunamo kolicnik iz formule.
	fld st				## stek: E,xp,ctg(xp),x,ctg(x),ctg(x)
	fsub st(0), st(3)		## stek: E,xp,ctg(xp),x,ctg(x),ctg(x)
					##       -ctg(xp)
	fld st(2)			## stek: E,xp,ctg(xp),x,ctg(x),ctg(x)
					##	 -ctg(xp),x
	fsub st(0),st(5)		## stek: E,xp,ctg(xp),x,ctg(x),ctg(x)
					##       -ctg(xp),x-xp
	fdivp				## stek: E,xp,ctg(xp),x,ctg(x),
					##       (ctg(x)-ctg(xp))/(x-xp)

	## Dodajemo kolicnik na prethodnu sumu E i skidamo ga sa steka.
	faddp st(5), st(0)		## stek: E,xp,ctg(xp),x,ctg(x)

	## Tekuci element postaje prethodni, pa zato njegovu vrednost i
	## vrednost njegovog kotangensa kopiramo na odgovarajuce pozicije,
	## kako bi stek imao istu formu kao i na pocetku iteracije. 
	fstp  st(2)			## stek: E,xp,ctg(x),x
	fstp  st(2)			## stek: E,x,ctg(x)

	loop main_loop

	## Skidamo sa steka dve nepotrebne vrednosti. Na steku ostaje samo
	## povratna vrednost.
	fcompp				## stek: E

done:
	## Epilog funkcije
	pop esi
	leave
	ret
	