.intel_syntax noprefix


.text
.global variance

###########################################################################
##
## Funkcija izracunava disperziju slucajne velicine y = e^x/(x+1), gde je x
## diskretna slucajna velicina cije su vrednosti date u nizu x duzine n.
## Pretpostavlja se da su sve vrednosti slucajne velicine x jednako verovatne
## (sa verovatnocom 1/n).
##	
## double variance(double * x, int n); 
##
## -- double * x -- [ebp+8]  -- pokazivac na niz vrednosti velicine x
## -- int n      -- [ebp+12] -- broj vrednosti slucajne velicine x
##
##########################################################################

variance:
	## Prolog funkcije
	enter 0,0
	push esi

	## U registar ecx smestamo n. U registar esi smestamo adresu niza
	## vrednosti velicine x.
	mov ecx, [ebp+12]
	mov esi, [ebp+8]

	## Slucaj praznog niza (ovo ne bi trebalo da se desi, po uslovu zadatka)
	jecxz done

	## Ucitavamo nulu.
	fldz                          ## stek: 0 = S

	## Petlja u kojoj se racuna E(y) = 1/n * sum_i(y_i), gde je
	## y_i = e^x_i/(x_i+1)
mean_loop:
	## Ucitavamo sledecu vrednost x_i
	fld qword ptr [esi]	      ## stek: S,x_i
	add esi,8

	## Racunamo e^x_i
	fld st(0)		      ## stek: S,x_i,x_i
	fldl2e			      ## stek: S,x_i,x_i,log_2(e)
	fmulp			      ## stek: S,x_i,x_i*log_2(e)=R
	fld st(0)		      ## stek: S,x_i,R,R
	frndint                       ## stek: S,x_i,R,int(R)
	fsub st(1), st(0)             ## stek: S,x_i,R-int(R)=frac(R),int(R)
	fxch			      ## stek: S,x_i,int(R),frac(R)
	f2xm1			      ## stek: S,x_i,int(R),2^frac(R)-1
	fld1			      ## stek: S,x_i,int(R),2^frac(R)-1,1
	faddp			      ## stek: S,x_i,int(R),2^frac(R)
	fscale			      ## stek: S,x_i,int(R),2^(frac(R)+int(R))
				      ## stek: S,x_i,int(R),2^R
	fxch			      ## stek: S,x_i,2^R,int(R)
	fcomp			      ## stek: S,x_i,2^R=e^x_i

	## Racunamo y_i i dodajemo ga na sumu
	fxch                          ## stek: S,e^x_i,x_i
	fld1                          ## stek: S,e^x_i,x_i,1
	faddp			      ## stek: S,e^x_i,x_i+1
	fdivp			      ## stek: S,e^x_i/(x_i+1)=y_i
	faddp			      ## stek: S+y_i = S'

	## Sledeca iteracija
	loop mean_loop

	## Delimo sumu sa n
	fidiv dword ptr [ebp+12]      ## stek: S/n = E(y)


	## Ucitavamo ponovo iste vrednosti u ecx i esi
	mov ecx, [ebp+12]
	mov esi, [ebp+8]

	## Ucitavamo nulu.
	fldz			      ## stek: E(y), 0 = S

	## Petlja u kojoj se racuna D(y) = 1/n*sum_i(y_i-E(y))^2
variance_loop:
	## Ucitavamo sledecu vrednost  x_i
	fld qword ptr [esi]	      ## stek: E(y),S,x_i
	add esi,8


	## Racunamo e^x_i
	fld st(0)		      ## stek: E(y),S,x_i,x_i
	fldl2e			      ## stek: E(y),S,x_i,x_i,log_2(e)
	fmulp			      ## stek: E(y),S,x_i,x_i*log_2(e)=R
	fld st(0)		      ## stek: E(y),S,x_i,R,R
	frndint                       ## stek: E(y),S,x_i,R,int(R)
	fsub st(1), st(0)             ## stek: E(y),S,x_i,R-int(R)=frac(R),
				      ##       int(R)
	fxch			      ## stek: E(y),S,x_i,int(R),frac(R)
	f2xm1			      ## stek: E(y),S,x_i,int(R),2^frac(R)-1
	fld1			      ## stek: E(y),S,x_i,int(R),2^frac(R)-1,1
	faddp			      ## stek: E(y),S,x_i,int(R),2^frac(R)
	fscale			      ## stek: E(y),S,x_i,int(R),
				      ##       2^(frac(R)+int(R))
				      ## stek: E(y),S,x_i,int(R),2^R
	fxch			      ## stek: E(y),S,x_i,2^R,int(R)
	fcomp			      ## stek: E(y),S,x_i,2^R=e^x_i

	## Racunamo (y_i - E(y))^2 i dodajemo ga na sumu
	fxch                          ## stek: E(y),S,e^x_i,x_i
	fld1                          ## stek: E(y),S,e^x_i,x_i,1
	faddp			      ## stek: E(y),S,e^x_i,x_i+1
	fdivp			      ## stek: E(y),S,e^x_i/(x_i+1)=y_i
	fsub st(0),st(2)	      ## stek: E(y),S,(y_i-E(y))
	fld st(0)		      ## stek: E(y),S,(y_i-E(y)),(y_i-E(y))
	fmulp 			      ## stek: E(y),S,(y_i-E(y))^2
	faddp			      ## stek: E(y),S+(y_i-E(y))^2 = S'

	## Sledeca iteracija
	loop variance_loop

	## Delimo sumu sa n
	fidiv dword ptr [ebp+12]      ## stek: E(y),S/n = D(y)

	## Uklanjamo sa steka vrednost E(y) koja je nepotrebna.
	fxch			      ## stek: D(y), E(y)
	fcomp			      ## stek: D(y)
	
done:	
	## Epilog funkcije
	pop esi
	leave
	ret
	