.intel_syntax noprefix


.text
.global int_to_string

###########################################################################
##
## Funkcija odredjuje zapis nenegativnog broja x u datoj osnovi b i formira
## string s koji sadrzi zapis. Pretpostavlja se da je 2 <= b <= 36, kao i da
## se za cifre koriste karakteri 0-9, A-Z (onoliko koliko ih je potrebno, u
## zavisnosti od osnove). Pretpostavlja se da zapis nece imati vise od 80
## karaktera.
##	
## void int_to_string(int x, int b, char *s);
##
## -- int x   -- [ebp+8]  -- broj ciji se zapis trazi.
## -- int b   -- [ebp+12] -- osnova
## -- char *s -- [ebp+16] -- pokazivac na niz u koji treba smestiti string
##
##########################################################################

int_to_string:
	## Prolog funkcije
	enter 0,0
	push edi
	push esi
	push ebx

	## U registar eax smestamo broj x. U registar ebx smestamo osnovu b.
	## U registar edi smestamo adresu stringa s.
	mov eax, [ebp+8]
	mov ebx, [ebp+12]
	mov edi, [ebp+16]

next_digit:
	## Delimo broj osnovom. Nakon toga je u registru eax celobrojni
	## kolicnik (za sledecu iteraciju), a u registru edx je ostatak,
	## koji odredjuje sledecu cifru (gledano sa desna u levo).
	xor edx, edx
	div ebx

	## Ispitujemo da li je ostatak u intervalu 0-9, ili je veci.
	cmp edx, 9
	ja letters

	## Ako je cifra 0-9 u pitanju, tada je dovoljno na ostatak dodati '0',
	## da bismo dobili ASCII kod odgovarajuce cifre.
	add dl, '0'
	jmp store
	
letters:
	## Ako je ostatak veci od 9, tada se za zapis cifre koristi
	## slovo. Odgovarajuci ASCII kod dobijamo tako sto oduzmemo 10 i
	## dodamo 'A'.
	sub dl, 10
	add dl, 'A'
	
store:
	## Smestamo karakter na sledecu poziciju u nizu i pomeramo pokazivac
	## edi. 
	mov byte ptr [edi], dl
	inc edi

	## Utvrdjujemo da li je kolicnik u eax nula. Ako jeste,tada je
	## algoritam izdvajanja cifara zavrsen. Ako nije, prelazimo na sledecu
	## iteraciju. 
	cmp eax, 0
	jne next_digit

	## Zatvaramo string karakterom '\0'.
	mov byte ptr [edi], 0

	## Sada je potrebno okrenuti string, jer su cifre u njemu u pogresnom
	## redosledu (prva je cifra najmanje tezine). Postavljamo edi na
	## adresu poslednjeg karaktera, a esi na adresu prvog karaktera.  
	dec edi
	mov esi, [ebp+16]

next_pair:
	## Dokle god se pokazivaci esi i edi ne ukrste...
	cmp esi, edi
	jae done

	## Zamenjujemo karaktere na koje pokazuju esi i edi.
	mov al, byte ptr [esi]
	mov ah, byte ptr [edi]
	mov byte ptr [edi], al
	mov byte ptr [esi], ah

	## Uvecavamo esi i umanjujemo edi, a zatim prelazimo na sledecu
	## iteraciju. 
	inc esi
	dec edi
	jmp next_pair

done:	
	## Epilog funkcije
	pop ebx
	pop esi
	pop edi
	leave
	ret
	