﻿using System;
using System.Collections.Generic;

namespace Vector3
{
    class DynamicVector<T> : IEnumerable<T>
    {
        private T[] _Elements;
        private int _Capacity;
        private int _Size; 

        public DynamicVector(int initial_capacity = 10)
        {
            _Capacity = initial_capacity;
            _Size = 0;
            _Elements = new T[_Capacity];
        }

        public int Capacity
        {
            get
            {
                return _Capacity;
            }
            set
            {
                if (value > _Capacity)
                {
                    T[] temp = new T[value];
                    for (int i = 0; i < _Size; i++)
                        temp[i] = _Elements[i];
                    _Elements = temp;
                    _Capacity = value;
                }
            }
        }

        public int Size
        {
            get
            {
                return _Size;
            }
            private set
            {
                _Size = value;
            }
        }

        public T this[int i]
        {
            get
            {
                return _Elements[i];
            }

            set
            {
                _Elements[i] = value;
            }
        }

        public void PushBack(T obj)
        {
            if (Size == Capacity)
                Capacity = (int)(Capacity * 1.35);
            this[Size++] = obj;
        }
        public T PopBack()
        {
            return this[--Size];
        }

        public T Back()
        {
            return this[Size - 1];
        }

        public IEnumerator<T> GetEnumerator()
        {
            for (int i = 0; i < Size; i++)
                yield return this[i];
        }


        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            throw new NotImplementedException();
        }
    }

}