﻿using System;
using System.Collections.Generic;

namespace Vector3
{
    class Program
    {

        static IEnumerable<int> getDivisors(int n)
        {
            for(int i = 1; i <= n; i++)
            {
                if (n % i == 0)
                    yield return i;
            }
        }

        static void Main(string[] args)
        {

            DynamicVector<int> vec = new DynamicVector<int>();
            Random rand = new Random();

            for (int i = 0; i < 50; i++)
            {
                vec.PushBack(rand.Next(0, 500));
                Console.WriteLine("Elem: {0} Size: {1} Capacity: {2}",
                                   vec.Back(), vec.Size, vec.Capacity);
            }

            IEnumerator<int> enumerator = vec.GetEnumerator();

            while (enumerator.MoveNext())
                Console.WriteLine(enumerator.Current);

            foreach (int x in vec)
                Console.WriteLine("foreach: {0}", x);

            IEnumerable<int> divisors = getDivisors(60);

            foreach (int d in divisors)
                Console.WriteLine("divisor: {0}", d);

        }
    }
}
