﻿using System;
using System.Collections.Generic;

namespace Vector3
{
    class DynamicVector<T> : IEnumerable<T>
    {
        private T[] _Elements;
        private int _Capacity;
        private int _Size;

        public class Enumerator : IEnumerator<T>
        {
            private int _Index;
            private DynamicVector<T> _Vector;

            public Enumerator(DynamicVector<T> vec)
            {
                _Index = -1;
                _Vector = vec;
            }

            public T Current
            {
                get 
                {
                    return _Vector[_Index];      
                }
            }

            public void Dispose()
            {

            }

           

            public bool MoveNext()
            {
                if (_Index == _Vector.Size)
                    return false;
                else
                {
                    _Index++;

                    if (_Index == _Vector.Size)
                        return false;
                    else
                        return true;
                }
            }

            public void Reset()
            {
                _Index = -1;
            }

            object System.Collections.IEnumerator.Current
            {
                get { throw new NotImplementedException(); }
            }
        }

        public DynamicVector(int initial_capacity = 10)
        {
            _Capacity = initial_capacity;
            _Size = 0;
            _Elements = new T[_Capacity];
        }

        public int Capacity
        {
            get
            {
                return _Capacity;
            }
            set
            {
                if (value > _Capacity)
                {
                    T[] temp = new T[value];
                    for (int i = 0; i < _Size; i++)
                        temp[i] = _Elements[i];
                    _Elements = temp;
                    _Capacity = value;
                }
            }
        }

        public int Size
        {
            get
            {
                return _Size;
            }
            private set
            {
                _Size = value;
            }
        }

        public T this[int i]
        {
            get
            {
                return _Elements[i];
            }

            set
            {
                _Elements[i] = value;
            }
        }

        public void PushBack(T obj)
        {
            if (Size == Capacity)
                Capacity = (int)(Capacity * 1.35);
            this[Size++] = obj;
        }
        public T PopBack()
        {
            return this[--Size];
        }

        public T Back()
        {
            return this[Size - 1];
        }

        public IEnumerator<T> GetEnumerator()
        {
            return new Enumerator(this);
        }

       // public IEnumerator  GetEnumerator()
        //{
         //   return new VectorEnumerator<T>(this);
        //}


        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            throw new NotImplementedException();
        }
    }

}