﻿using System;

namespace Vector
{
    class DynamicVector
    {
        private object[] _Elements;
        private int _Capacity;
        private int _Size;

        public DynamicVector(int initial_capacity = 10)
        {
            _Capacity = initial_capacity;
            _Size = 0;
            _Elements = new object[_Capacity];
        }

        public int Capacity
        {
            get
            {
                return _Capacity;
            }
            set
            {
                if (value > _Capacity)
                {
                    object[] temp = new object[value];
                    for (int i = 0; i < _Size; i++)
                        temp[i] = _Elements[i];
                    _Elements = temp;
                    _Capacity = value;
                }
            }
        }

        public int Size
        {
            get
            {
                return _Size;
            }
            private set
            {
                _Size = value;
            }
        }

        public object this[int i]
        {
            get
            {
                return _Elements[i];
            }

            set
            {
                _Elements[i] = value;
            }
        }

        public void PushBack(object obj)
        {
            if (Size == Capacity)
                Capacity = (int)(Capacity * 1.35);
            this[Size++] = obj;
        }
        public object PopBack()
        {
            return this[--Size];
        }

        public object Back()
        {
            return this[Size - 1];
        }
    }

}