﻿using System;

namespace Structure
{
    struct Complex
    {
        private double _Real;
        private double _Imaginary;

        public 
            Complex(double real, double imaginary)
        {
            _Real = real;
            _Imaginary = imaginary;
        }

        public double Real
        {
            get
            {
                return _Real;
            }

            set
            {
                _Real = value;
            }
        }

        public double Imaginary
        {
            get
            {
                return _Imaginary;
            }

            set
            {
                _Imaginary = value;
            }
        }

        public double Absolute
        {
            get
            {
                return Math.Sqrt(_Real * _Real + _Imaginary * _Imaginary);
            }
        }

        public double Argument
        {
            get
            {
                return Math.Atan2(_Imaginary, _Real);
            }
        }

        public static Complex operator ~ (Complex z)
        {
            return new Complex(z.Real, -z.Imaginary);
        }

        public static Complex operator - (Complex z)
        {
            return new Complex(-z.Real, -z.Imaginary);
        }

        public static Complex operator + (Complex z1, Complex z2)
        {
            return new Complex(z1.Real + z2.Real, z1.Imaginary + z2.Imaginary);
        }

        public static Complex operator - (Complex z1, Complex z2)
        {
            return new Complex(z1.Real - z2.Real, z1.Imaginary - z2.Imaginary);
        }

        public static Complex operator  * (Complex z1, Complex z2)
        {
            return new Complex(z1.Real * z2.Real - z1.Imaginary * z2.Imaginary, 
                               z1.Real * z2.Imaginary + z2.Real * z1.Imaginary);
        }

        public static Complex operator / (Complex z1, Complex z2)
        {
            Complex temp = z1 * ~z2;

            return new Complex(temp.Real / (z2.Absolute * z2.Absolute),
                               temp.Imaginary / (z2.Absolute * z2.Absolute));
        }

    }
}