﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Point2
{
    class Point
    {
        private static Point _center;

        static Point()
        {
            _center = new Point();
        }

        public static Point Center
        {
            get
            {
                return _center;
            }
        }

        private double _x;
        private double _y;

        public Point(double x = 0.0, double y = 0.0)
        {
            _x = x;
            _y = y;
        }

        public double X
        {
            get
            {
                return _x;
            }

            set
            {
                _x = value;
            }
        }

        public double Y
        {
            get
            {
                return _y;
            }

            set
            {
                _y = value;
            }
        }

        public static double calculateDistance(Point p1, Point p2)
        {
            return System.Math.Sqrt((p1.X - p2.X) * (p1.X - p2.X) +
                                    (p1.Y - p2.Y) * (p1.Y - p2.Y));
        }

        public double Norm
        {
            get
            {
                return calculateDistance(_center, this);
            }
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
        //       Point p = new Point(3,4);
            Point p = new Point() { X = 3, Y = 4 };
            System.Console.WriteLine(p.Norm);
        }
    }
}

