﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Point1
{
    class Point
    {
        private static Point _center = new Point();

        public static Point getCenter()
        {
            return _center;
        }

        private double _x;
        private double _y;

        public Point(double x, double y)
        {
            _x = x;
            _y = y;
        }

        public Point()
            : this(0.0, 0.0)
        {}

        public double getX()
        {
            return _x;
        }

        public void setX(double x)
        {
            _x = x;
        }

        public double getY()
        {
            return _y;
        }

        public void setY(double y)
        {
            _y = y;
        }

        public static double calculateDistance(Point p1, Point p2)
        {
            return System.Math.Sqrt((p1.getX() - p2.getX()) * (p1.getX() - p2.getX()) +
                                    (p1.getY() - p2.getY()) * (p1.getY() - p2.getY()));
        }

        public double getNorm()
        {
            return calculateDistance(_center, this);
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            Point p = new Point(2, 3);

            System.Console.WriteLine(p.getNorm());

        }
    }
}
