﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Parameters
{
    struct Counter
    {
        private int _count;

        public void incrementCounter()
        {
            _count++;
        }

        public int Count {
            get 
            {
                return _count;
            }
    }

    }

    class Program {

        static void f(Counter c)
        {
            c.incrementCounter();

        }

        static void swapValuesBad(int x, int y)
        {
            int t = x;
            x = y;
            y = x;
        }

        /* ref parametri */
        static void swapValuesGood(ref int x, ref int y)
        {
            int t = x;
            x = y;
        
            y = t;
        }

        /* out parametri */
        static void addNumbers(int x, int y, out int s)
        {
            s = x + y;
        }

        /* promenljivi broj argumenata */
        static void addNumbers(out int s, params int[] args)
        {
            s = 0;

            for (int i = 0; i < args.Length; i++)
                s += args[i];
        }

        static void Main(string[] args)
        {

            Counter counter = new Counter();

            f(counter);

            Console.WriteLine(counter.Count);


            string line = System.Console.ReadLine();
            int x = Convert.ToInt32(line, null);
            line = System.Console.ReadLine();
            int y = Convert.ToInt32(line, null);
            Program.swapValuesBad(x, y);
            System.Console.WriteLine("X: {0} Y: {1}", x, y);

            Program.swapValuesGood(ref x, ref y);
            System.Console.WriteLine("X: {0} Y: {1}", x, y);

            int s;
            Program.addNumbers(x, y, out s);

            System.Console.WriteLine("X + Y = {0}", s);

            Program.addNumbers(out s, x, y);
            System.Console.WriteLine("X + Y = {0}", s); 
         }
    }
}


