﻿using System;

namespace Object
{
    class TestClass
    {
        public int X
        {
            
            get;
            set;
        }

        /*
         * Ova metoda ispituje da li je objekat jednak (ekvivalentan)
         * objektu obj. Podrazumevano, implementaija u klasi object 
         * vraca true akko su u pitanju objekti na istoj adresi u memoriji
         * tj. ako je obj upravo objekat za koji se Equals poziva. 
         * Ovo ponasanje je pozeljno redefinisati, ako je u pitanju tip
         * za koji je relacija jednakosti drugacije definisana.
         */
        public override bool Equals(object obj)
        {
            /*
             * Staticka metoda object.ReferenceEquals() prihvata dva 
             * objekta i vraca true akko se oba odnose na isti objekat
             * u memoriji. Na ovaj nacin brzo proveravamo da li je isti
             * objekat u pitanju.
             */
            if (object.ReferenceEquals(this, obj))
                return true;

            /* Proveravamo da li su objekti istog tipa. Ovo je moguce
             * uraditi tako sto se pozove obj.GetType() metoda koja vraca
             * objekat System.Type klase koja sadrzi metainformacije o
             * tipu. Izmedju ostalog, sadrzi svojstvo Name koja predstavlja
             * ime tipa. Ako ova imena nistu jednaka, tada objekti nisu
             * istog tipa, pa vracamo false */
            if (obj.GetType().Name != this.GetType().Name)
                return false;

            /* Ako su objekti istog tipa, tada vrsimo konverziju na dole
             * kako bismo dobili instancu TestClass */
            TestClass c = (TestClass)obj;

            /* Objekti se smatraju jednakima ako im je svojstvo X jednako */
            return c.X == this.X;            
        }

        /* 
         Operator == je takodje neophodno redefinisati kad kod se redefinise
         * i metoda Equals(), i trebalo bi da vraca rezultat koji je konzistentan
         * sa onim sto vraca Equals(). Najjednostavni nacin je da prosto 
         * pozovemo t.Equals().
         */
        public static bool operator == (TestClass t, object o)
        {
            return t.Equals(o);
        }

        public static bool operator != (TestClass t, object o)
        {
            return !(t == o);
        }

        /* ToString() metoda omogucava lep ispis objekta pomocu
         * Console.WriteLine() metode. Generalno, kad god je potreban
         * string, tada se objekat implicitno konvertuje u string 
         * pozivom ove metode 
         */
        public override string ToString()
        {
            return "Value: " + X;
        }

        /* Ova metoda treba da bude implementirana ako planiramo da kreiramo
         * kolekcije objekata ovog tipa koje su zasnovane na hes tabelama.
         * Uslov koji hes funkcija treba da ispuni (pored toga da sto ravnomernije
         * rasporedjuje elemente po tabeli) je da dva objekta koji se smatraju
         * jednakima moraju imati jednake vrednosti hes funkcije */
        public override int GetHashCode()
        {
            return X.GetHashCode();
        }
    }
}
