﻿using System;

namespace Matrix
{

    class Matrix
    {
        private int _m;
        private int _n;

        private double[,] _mat;

        public Matrix(int m, int n)
        {
            _m = m;
            _n = n;
            _mat = new double[m, n];
        }

        public int RowNum
        {
            get
            {
                return _m;
            }
        }

        public int ColNum
        {
            get
            {
                return _n;
            }
        }

        /* indexer */
        public double this[int i, int j]
        {
            get
            {
                return _mat[i, j];
            }
            set
            {
                _mat[i, j] = value; 
            }
        }

        public static Matrix operator +(Matrix a, Matrix b)
        {
            if (a.RowNum != b.RowNum || a.ColNum != b.ColNum)
                throw new Exception("Dimension error!");

            Matrix result = new Matrix(a.RowNum, a.ColNum);

            for (int i = 0; i < result.RowNum; i++)
                for (int j = 0; j < result.ColNum; j++)
                    result[i, j] = a[i, j] + b[i, j];

            return result;
        }

        public static Matrix operator -(Matrix a)
        {
            Matrix result = new Matrix(a.RowNum, a.ColNum);

            for (int i = 0; i < result.RowNum; i++)
                for (int j = 0; j < result.ColNum; j++)
                    result[i, j] = -a[i, j];

            return result;
        }

        public static Matrix operator - (Matrix a, Matrix b)
        {
            if (a.RowNum != b.RowNum || a.ColNum != b.ColNum)
                throw new Exception("Dimension error!");

            Matrix result = new Matrix(a.RowNum, a.ColNum);

            for (int i = 0; i < result.RowNum; i++)
                for (int j = 0; j < result.ColNum; j++)
                    result[i, j] = a[i, j] - b[i, j];

            return result;
        }

        public static Matrix operator *(Matrix a, Matrix b)
        {
            if (a.ColNum != b.RowNum)
                throw new Exception("Dimension error!");

            Matrix result = new Matrix(a.RowNum, b.ColNum);

            for (int i = 0; i < result.RowNum; i++)
                for (int j = 0; j < result.ColNum; j++)
                    for (int k = 0; k < a.ColNum; k++)
                        result[i, j] += a[i, k] * b[k, j];

            return result;
        }

        public static Matrix ReadMatrix(int m = 0, int n = 0)
        {
            Matrix a = null;

            if (m == 0 || n == 0)
            {
                string dimLine = System.Console.ReadLine();

                string firstDim = dimLine.Substring(0, dimLine.IndexOfAny(new char[] { ' ' }, 0));
                string secondDim = dimLine.Substring(dimLine.IndexOfAny(new char[] { ' ' }, 0));

                a = new Matrix(int.Parse(firstDim), int.Parse(secondDim));
            }
            else
            {
                a = new Matrix(m, n);
            }

            for (int i = 0; i < a.RowNum; i++)
            {
                string rowLine = System.Console.ReadLine();

                for (int j = 0; j < a.ColNum; j++)
                {
                    rowLine = rowLine.Trim();
                    int indexOfSpace = rowLine.IndexOfAny(new char[] { ' ' }, 0);
                    string firstNumberStr;
                    if (indexOfSpace > 0)
                        firstNumberStr = rowLine.Substring(0, indexOfSpace);
                    else
                        firstNumberStr = rowLine;

                    if (indexOfSpace > 0)
                        rowLine = rowLine.Substring(indexOfSpace);
                    else
                        rowLine = null;

                    a[i, j] = double.Parse(firstNumberStr);
                }
            }

            return a;

        }

        public void PrintMatrix()
        {

            for (int i = 0; i < this.RowNum; i++)
            {
                for (int j = 0; j < this.ColNum; j++)
                {
                    System.Console.Write(this[i, j] + " ");
                }
                System.Console.WriteLine("");
            }

        }

    }


}