﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace LinqIntro
{
    class Person
    {
        public string Name
        {
            set;
            get;
        }

        public string Gender
        {
            set;
            get;
        }


        public int YearOfBirth
        {
            set;
            get;
        }

	public override bool Equals(object obj)
	{
	   Person p = obj as Person;
	   if(p == null)
	     return false;
	   return p.Name == Name && p.Gender == Gender && p.YearOfBirth == YearOfBirth;
	}

    public static bool operator == (Person p, object o)
    {
        return Object.ReferenceEquals(p, o) || p.Equals(o);
    }

    public static bool operator != (Person p, object o)
    {
        return !(p == o);
    }

    public override int GetHashCode()
        {
            return Name.GetHashCode();
        }

   public override string ToString()
        {
            return Name + ", " + Gender + ", " + YearOfBirth;
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            HashSet<Person> persons = new HashSet<Person>();

            persons.Add(new Person() { Name = "Pera", Gender = "Male", YearOfBirth = 1990 });
            persons.Add(new Person() { Name = "Joca", Gender = "Male", YearOfBirth = 1987 });
            persons.Add(new Person() { Name = "Sava", Gender = "Male", YearOfBirth = 1975 });
            persons.Add(new Person() { Name = "Raka", Gender = "Male", YearOfBirth = 1993 });
            persons.Add(new Person() { Name = "Ana", Gender = "Female", YearOfBirth = 1990 });
            persons.Add(new Person() { Name = "Marija", Gender = "Female", YearOfBirth = 1984 });
            persons.Add(new Person() { Name = "Ivana", Gender = "Female", YearOfBirth = 1974 });
            persons.Add(new Person() { Name = "Sanja", Gender = "Female", YearOfBirth = 1992 });
           
            // LINQ metode:
            // 
            // kolekcija.Where(uslov) -- kreira novu kolekciju koja sadrzi samo one elemente
            //                            koji zadovoljavaju uslov. uslov je delegat koji vraca
            //                            bool, a prihvata parametar tipa elementa kolekcije.
            // kolekcija.Select(selektor) -- kreira novu kolekciju koja sadrzi elemente anonimnog
            //                             tipa koji nastaje tako sto se izdvoje zeljene vrednosti
            //                             iz elemenata originalne kolekcije. Selektor je delegat 
            //                             koji prihvata element originalne kolekcije i vraca bilo
            //                             sta (sta god zelimo da selektujemo)
            // kolekcija.OrderBy(vrednost) -- kreira novu kolekciju koja nastaje sortiranjem originalne
            //                               u rastucem poretku s obzirom na vrednost datu delegatom
            //                              koji prihvata element kolekcije, a vraca bilo koju vrednost
            //                              odredjenu elementom.
            // kolekcija.ThenBy(vrednost)  -- polazeci od kolekcije koja je vec uredjena po nekom kriterijumu
            //                              vrsi dodatno sortiranje po dopunskom kriterijumu.
            // kolekcija.OrderByDescending(), collection.ThenByDescending(), slicno kao i gore, samo opadajuce.
            //
            // kolekcija.GroupBy(delegat) -- kreira "kolekciju kolekcija", tj. kolekciju ciji su elementi kolekcije
            //                                nastale grupisanjem originalne kolekcije po datom kriterijumu.
            //                                Svaka kolekcija u kolekciji ima svojstvo Key koje predstavlja
            //                                vrednost grupisanja za tu grupu.
            // kolekcija.Count() -- vraca broj elemenata u kolekciji
            // kolekcija.Average(delegat) -- vraca prosek vrednosti odredjene delegatom koji prihvata element
            //                                kolekcije i vraca vrednost ciji se prosek racuna.
            // kolekcija.Max(delegat) -- vraca maksimum vrednosti
            // kolekcija.Min(delegat) -- vraca minimum vrednost 
            //
            // kolekcija.Any() -- vraca true akko je kolekcija neprazna (ima ulogu EXISTS-a u SQL-u).
            // kolekcija.Distinct() -- vraca kolekciju nastalu izbacivanjem duplikata iz originalne kolekcije.
            // kolekcija1.Join(kolekcija2, selektor1, selektor2, rselektor) -- spaja dve kolekcije, pri cemu
            //                                  selektor1 bira element spajanja iz prve, a selektor2 iz druge
            //                                  kolekcije. rselektor bira ono sto ce se selektovati iz rezultata
            //                                  koji nastaje spajanjem.
            

            

            // Izdvaja sve muskarce
            var males = persons.Where(x => x.Gender == "Male");

            foreach (Person x in males)
            {
                Console.WriteLine(x);
            }

            // Izdvaja sve devojke, selektuje samo imena
            var females = persons.Where(x => x.Gender == "Female").Select(x => x.Name);

            foreach (var x in females)
            {
                Console.WriteLine(x);
            }

            // Izdvaja sve osobe starije od 30 godina, selektuje ime i godinu rodjenja. Sortira po godini rodjenja, a zatim po imenima, rastuce.
            var olders = persons.Where(x => DateTime.Now.Year > x.YearOfBirth + 30).Select(x => new { x.Name, x.YearOfBirth }).OrderBy(x => x.YearOfBirth).ThenBy(x => x.Name);

            foreach (var x in olders)
            {
                Console.WriteLine(x);
            }

            // Izdvaja kolekciju grupa, pri cemu se grupisanje vrsi po polu.
            var groups = persons.GroupBy(x => x.Gender);

            // Za svaku grupu, prikazujemo kljuc grupisanja, a zatim i clanove grupe.
            foreach (var group in groups)
            {
                Console.WriteLine("Gender: " + group.Key);
                foreach (var elem in group)
                    Console.WriteLine(elem);
            }

            // Izdvajamo statistike o grupi: broj elemenata grupe, prosecnu vrednost godina clanova grupe.
            var groups_stat = groups.Select(x => new { Gender = x.Key, Count = x.Count(), Average = x.Average(y => (double)(DateTime.Now.Year - y.YearOfBirth)) });

            foreach (var s in groups_stat)
            {
                Console.WriteLine(s.Gender + " " + s.Count + " " + s.Average);
            }

            var pairs = persons.Where(x => x.Gender == "Male").Join(persons.Where(x => x.Gender == "Female"), x => x.YearOfBirth, x => x.YearOfBirth, (x, y) => new { Male = x.Name, Female = y.Name, x.YearOfBirth });

            foreach (var pair in pairs)
                Console.WriteLine(pair);
        }
    }
}
